/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntPredicate;

public final class Sliced<T>
implements Iterator<T> {
    private final Iterator<? extends T> iterator;
    private final int start;
    private int current;
    private IntPredicate end;

    public Sliced(int start, int count, Iterator<? extends T> iterator) {
        this(start, index -> index > start + count - 1, iterator);
    }

    public Sliced(int start, Iterator<? extends T> iterator) {
        this(start, any -> !iterator.hasNext(), iterator);
    }

    private Sliced(int start, IntPredicate end, Iterator<? extends T> iterator) {
        this.start = start;
        this.end = end;
        this.iterator = iterator;
        this.current = 0;
    }

    @Override
    public boolean hasNext() {
        this.skip();
        return !this.end.test(this.current) && this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("The iterator doesn't have items any more");
        }
        ++this.current;
        return this.iterator.next();
    }

    private void skip() {
        while (this.current < this.start && this.iterator.hasNext()) {
            this.iterator.next();
            ++this.current;
        }
    }
}

