/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.iterator;

import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class Synced<T>
implements Iterator<T> {
    private final Iterator<? extends T> iterator;
    private final ReadWriteLock lock;

    public Synced(Iterator<? extends T> iterator) {
        this(new ReentrantReadWriteLock(), iterator);
    }

    public Synced(ReadWriteLock lock, Iterator<? extends T> iterator) {
        this.iterator = iterator;
        this.lock = lock;
    }

    @Override
    public boolean hasNext() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.iterator.hasNext();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public T next() {
        this.lock.writeLock().lock();
        try {
            T t2 = this.iterator.next();
            return t2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

