/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.list;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.cactoos.list.ListOf;

public final class JoinedListIterator<T>
implements ListIterator<T> {
    private final List<? extends ListIterator<? extends T>> listiters;
    private final AtomicInteger cursorlit;
    private final AtomicInteger cursor;

    @SafeVarargs
    public JoinedListIterator(ListIterator<? extends T> ... items) {
        this(new ListOf<ListIterator<? extends T>>(items));
    }

    public JoinedListIterator(T item, ListIterator<? extends T> items) {
        this(new ListOf<ListIterator>(new ListOf<Object>(item).listIterator(), items));
    }

    public JoinedListIterator(ListIterator<? extends T> items, T item) {
        this(new ListOf<ListIterator>(items, new ListOf<Object>(item).listIterator()));
    }

    public JoinedListIterator(List<? extends ListIterator<? extends T>> items) {
        this.listiters = items;
        this.cursorlit = new AtomicInteger(-1);
        this.cursor = new AtomicInteger(-1);
    }

    @Override
    public boolean hasNext() {
        while (!this.currentListIterator().hasNext() && this.listHasNextElt()) {
            this.cursorlit.getAndIncrement();
        }
        return this.currentListIterator().hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T next = this.currentListIterator().next();
        this.cursor.getAndIncrement();
        return next;
    }

    @Override
    public boolean hasPrevious() {
        while (!this.currentListIterator().hasPrevious() && this.listHasPreviousElt()) {
            this.cursorlit.getAndDecrement();
        }
        return this.currentListIterator().hasPrevious();
    }

    @Override
    public T previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        T previous = this.currentListIterator().previous();
        this.cursor.getAndDecrement();
        return previous;
    }

    @Override
    public int nextIndex() {
        return this.cursor.get() + 1;
    }

    @Override
    public int previousIndex() {
        int previousidx = -1;
        if (this.hasPrevious()) {
            previousidx = this.cursor.get() - 1;
        }
        return previousidx;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(T elt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T elt) {
        throw new UnsupportedOperationException();
    }

    private boolean listHasNextElt() {
        return this.cursorlit.get() + 1 <= this.listiters.size() - 1;
    }

    private boolean listHasPreviousElt() {
        return this.cursorlit.get() - 1 >= 0;
    }

    private ListIterator<? extends T> currentListIterator() {
        ListIterator<Object> current = this.cursorlit.get() == -1 ? Collections.emptyListIterator() : this.listiters.get(this.cursorlit.get());
        return current;
    }
}

