/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.list;

import java.util.ListIterator;

public final class ListIteratorNoNulls<T>
implements ListIterator<T> {
    private final ListIterator<T> listiterator;

    public ListIteratorNoNulls(ListIterator<T> src) {
        this.listiterator = src;
    }

    @Override
    public boolean hasNext() {
        return this.listiterator.hasNext();
    }

    @Override
    public T next() {
        T next = this.listiterator.next();
        if (next == null) {
            throw new IllegalStateException("Next item is NULL");
        }
        return next;
    }

    @Override
    public boolean hasPrevious() {
        return this.listiterator.hasPrevious();
    }

    @Override
    public T previous() {
        T prev = this.listiterator.previous();
        if (prev == null) {
            throw new IllegalStateException("Previous item is NULL");
        }
        return prev;
    }

    @Override
    public int nextIndex() {
        return this.listiterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.listiterator.previousIndex();
    }

    @Override
    public void remove() {
        this.listiterator.remove();
    }

    @Override
    public void set(T item) {
        if (item == null) {
            throw new IllegalArgumentException("Item can't be NULL in #set(T)");
        }
        this.listiterator.set(item);
    }

    @Override
    public void add(T item) {
        if (item == null) {
            throw new IllegalArgumentException("Item can't be NULL in #add(T)");
        }
        this.listiterator.add(item);
    }
}

