/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.map;

import java.util.HashMap;
import java.util.Map;
import org.cactoos.Func;
import org.cactoos.iterable.IterableOf;
import org.cactoos.iterable.Joined;
import org.cactoos.iterable.Mapped;
import org.cactoos.map.MapEntry;
import org.cactoos.map.MapEnvelope;

public final class MapOf<X, Y>
extends MapEnvelope<X, Y> {
    public MapOf(X key, Y value) {
        this(new MapEntry<X, Y>(key, value));
    }

    @SafeVarargs
    public MapOf(Map.Entry<? extends X, ? extends Y> ... list) {
        this(new IterableOf<Map.Entry<? extends X, ? extends Y>>(list));
    }

    public MapOf(Map<? extends X, ? extends Y> src, X key, Y value) {
        this(src, new MapEntry<X, Y>(key, value));
    }

    @SafeVarargs
    public MapOf(Map<? extends X, ? extends Y> src, Map.Entry<? extends X, ? extends Y> ... list) {
        this(src, new IterableOf<Map.Entry<? extends X, ? extends Y>>(list));
    }

    public <Z> MapOf(Func<? super Z, ? extends X> key, Func<? super Z, ? extends Y> value, Iterable<? extends Z> list) {
        this((? super Z item) -> new MapEntry(key.apply((Object)item), value.apply((Object)item)), list);
    }

    public <Z> MapOf(Func<? super Z, ? extends X> key, Func<? super Z, ? extends Y> value, Map<? extends X, ? extends Y> src, Iterable<Z> list) {
        this((? super Z item) -> new MapEntry(key.apply((Object)item), value.apply((Object)item)), src, list);
    }

    public <Z> MapOf(Func<? super Z, Map.Entry<? extends X, ? extends Y>> entry, Iterable<? extends Z> list) {
        this(new Mapped<Map.Entry<? extends X, ? extends Y>>(entry, list));
    }

    public <Z> MapOf(Func<? super Z, Map.Entry<? extends X, ? extends Y>> entry, Map<? extends X, ? extends Y> src, Iterable<? extends Z> list) {
        this(src, new Mapped<Map.Entry<? extends X, ? extends Y>>(entry, list));
    }

    public MapOf(Map<? extends X, ? extends Y> src, Iterable<Map.Entry<? extends X, ? extends Y>> list) {
        this(new Joined<Map.Entry<? extends X, ? extends Y>>(src.entrySet(), list));
    }

    public MapOf(Iterable<Map.Entry<? extends X, ? extends Y>> entries) {
        super(MapOf.make(entries));
    }

    private static <X, Y> Map<X, Y> make(Iterable<Map.Entry<? extends X, ? extends Y>> entries) {
        HashMap<X, Y> map = new HashMap<X, Y>(0);
        for (Map.Entry<X, Y> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }
}

