/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.number;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.cactoos.Scalar;
import org.cactoos.scalar.Unchecked;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID", "SE_BAD_FIELD"})
public final class NumberOfScalars
extends Number {
    private final Scalar<Long> lnum;
    private final Scalar<Integer> inum;
    private final Scalar<Float> fnum;
    private final Scalar<Double> dnum;

    public NumberOfScalars(Scalar<? extends Number> nbr) {
        this(() -> ((Number)nbr.value()).longValue(), () -> ((Number)nbr.value()).intValue(), () -> Float.valueOf(((Number)nbr.value()).floatValue()), () -> ((Number)nbr.value()).doubleValue());
    }

    public NumberOfScalars(Scalar<Long> lnm, Scalar<Integer> inm, Scalar<Float> fnm, Scalar<Double> dnm) {
        this.lnum = lnm;
        this.inum = inm;
        this.fnum = fnm;
        this.dnum = dnm;
    }

    @Override
    public int intValue() {
        return new Unchecked<Integer>(this.inum).value();
    }

    @Override
    public long longValue() {
        return new Unchecked<Long>(this.lnum).value();
    }

    @Override
    public float floatValue() {
        return new Unchecked<Float>(this.fnum).value().floatValue();
    }

    @Override
    public double doubleValue() {
        return new Unchecked<Double>(this.dnum).value();
    }

    public String toString() {
        return Double.toString(this.doubleValue());
    }

    public boolean equals(Object obj) {
        return obj instanceof Number && Double.compare(this.doubleValue(), ((Number)obj).doubleValue()) == 0;
    }

    public int hashCode() {
        return Double.hashCode(this.doubleValue());
    }
}

