/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.cactoos.Func;
import org.cactoos.Proc;
import org.cactoos.Scalar;
import org.cactoos.func.FuncOf;
import org.cactoos.iterable.IterableOf;
import org.cactoos.iterable.Mapped;
import org.cactoos.scalar.And;
import org.cactoos.scalar.ScalarOf;
import org.cactoos.text.FormattedText;

public final class AndInThreads
implements Scalar<Boolean> {
    private final ExecutorService service;
    private final Iterable<? extends Scalar<Boolean>> iterable;
    private final boolean shut;

    @SafeVarargs
    public <X> AndInThreads(Func<? super X, Boolean> func, X ... src) {
        this(func, (Iterable<? extends X>)new IterableOf<X>(src));
    }

    public <X> AndInThreads(Func<? super X, Boolean> func, Iterable<? extends X> src) {
        this(new Mapped<ScalarOf>(item -> new ScalarOf<Boolean>(() -> (Boolean)func.apply(item)), src));
    }

    @SafeVarargs
    public AndInThreads(Scalar<Boolean> ... src) {
        this(new IterableOf<Scalar<Boolean>>(src));
    }

    public AndInThreads(Iterable<? extends Scalar<Boolean>> src) {
        this(Executors.newCachedThreadPool(), src, true);
    }

    @SafeVarargs
    public <X> AndInThreads(ExecutorService svc, Proc<? super X> proc, X ... src) {
        this(svc, new FuncOf<X, Boolean>(proc, true), src);
    }

    @SafeVarargs
    public <X> AndInThreads(ExecutorService svc, Func<? super X, Boolean> func, X ... src) {
        this(svc, func, (Iterable<? extends X>)new IterableOf<X>(src));
    }

    public <X> AndInThreads(ExecutorService svc, Proc<? super X> proc, Iterable<? extends X> src) {
        this(svc, (Func<? super X, Boolean>)new FuncOf<X, Boolean>(proc, true), src);
    }

    public <X> AndInThreads(ExecutorService svc, Func<? super X, Boolean> func, Iterable<? extends X> src) {
        this(svc, new Mapped<ScalarOf>(item -> new ScalarOf<Boolean>(() -> (Boolean)func.apply(item)), src));
    }

    @SafeVarargs
    public AndInThreads(ExecutorService svc, Scalar<Boolean> ... src) {
        this(svc, new IterableOf<Scalar<Boolean>>(src));
    }

    public AndInThreads(ExecutorService svc, Iterable<? extends Scalar<Boolean>> src) {
        this(svc, src, false);
    }

    private AndInThreads(ExecutorService svc, Iterable<? extends Scalar<Boolean>> src, boolean sht) {
        this.service = svc;
        this.iterable = src;
        this.shut = sht;
    }

    @Override
    public Boolean value() throws Exception {
        LinkedList<Future<Boolean>> futures = new LinkedList<Future<Boolean>>();
        for (Scalar<Boolean> scalar : this.iterable) {
            futures.add(this.service.submit(scalar::value));
        }
        boolean result = new And(Future::get, futures).value();
        if (this.shut) {
            this.service.shutdown();
            try {
                if (!this.service.awaitTermination(1L, TimeUnit.MINUTES)) {
                    throw new IllegalStateException(new FormattedText("Can't terminate the service, result=%b", result).asString());
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(interruptedException);
            }
        }
        return result;
    }
}

