/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import org.cactoos.Func;
import org.cactoos.Scalar;
import org.cactoos.func.UncheckedFunc;
import org.cactoos.scalar.InheritanceLevel;
import org.cactoos.text.FormattedText;
import org.cactoos.text.UncheckedText;

public final class Checked<T, E extends Exception>
implements Scalar<T> {
    private final Func<? super Exception, ? extends E> func;
    private final Scalar<? extends T> origin;

    public Checked(Scalar<? extends T> scalar, Func<? super Exception, ? extends E> fnc) {
        this.func = fnc;
        this.origin = scalar;
    }

    @Override
    public T value() throws E {
        try {
            return this.origin.value();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw this.wrappedException(ex);
        }
        catch (Exception ex) {
            throw this.wrappedException(ex);
        }
    }

    private E wrappedException(Exception exp) {
        Exception wrapped = (Exception)new UncheckedFunc<Exception, E>(this.func).apply(exp);
        int level = new InheritanceLevel(exp.getClass(), wrapped.getClass()).value();
        String message = wrapped.getMessage().replaceFirst(new UncheckedText(new FormattedText("%s: ", exp.getClass().getName())).asString(), "");
        if (level >= 0 && message.equals(exp.getMessage())) {
            wrapped = exp;
        }
        return (E)wrapped;
    }
}

