/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import org.cactoos.Bytes;
import org.cactoos.Scalar;
import org.cactoos.scalar.Ternary;

public final class Equality<T extends Bytes>
implements Scalar<Integer> {
    private final T left;
    private final T right;

    public Equality(T lft, T rght) {
        this.left = lft;
        this.right = rght;
    }

    @Override
    public Integer value() throws Exception {
        byte[] lft = this.left.asBytes();
        byte[] rght = this.right.asBytes();
        return (Integer)new Ternary<Integer>(() -> lft.length == rght.length, () -> {
            int result = 0;
            for (int idx = rght.length - 1; idx >= 0 && (result = lft[idx] - rght[idx]) == 0; --idx) {
            }
            return Integer.signum(result);
        }, () -> Integer.signum(lft.length - rght.length)).value();
    }
}

