/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import java.io.InputStream;
import java.util.Iterator;
import org.cactoos.Input;
import org.cactoos.Scalar;
import org.cactoos.Text;
import org.cactoos.scalar.ScalarEnvelope;

public final class LengthOf
extends ScalarEnvelope<Long> {
    public LengthOf(Iterable<?> items) {
        this(() -> {
            Iterator iterator = items.iterator();
            long size = 0L;
            while (iterator.hasNext()) {
                iterator.next();
                ++size;
            }
            return size;
        });
    }

    public LengthOf(Text text) {
        this(() -> text.asString().length());
    }

    public LengthOf(Input input) {
        this(input, 16384);
    }

    public LengthOf(Input input, int max) {
        this(() -> {
            if (max == 0) {
                throw new IllegalArgumentException("Cannot use a buffer limited to zero size");
            }
            try (InputStream stream = input.stream();){
                int len;
                byte[] buf = new byte[max];
                long length = 0L;
                do {
                    if ((len = stream.read(buf)) <= 0) continue;
                    length += (long)len;
                } while (len >= 0);
                Long l = length;
                return l;
            }
        });
    }

    private LengthOf(Scalar<Long> number) {
        super(number);
    }
}

