/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cactoos.BiFunc;
import org.cactoos.Scalar;
import org.cactoos.iterable.Mapped;
import org.cactoos.scalar.Constant;

public final class Reduced<T>
implements Scalar<T> {
    private final Iterable<? extends Scalar<? extends T>> items;
    private final BiFunc<? super T, ? super T, ? extends T> function;

    @SafeVarargs
    public Reduced(BiFunc<? super T, ? super T, ? extends T> reduce, T ... values) {
        this((BiFunc<? extends T, ? extends T, ? extends T>)reduce, (Iterable<Scalar<? extends T>>)new Mapped<Constant>(Constant::new, values));
    }

    public Reduced(Iterable<T> values, BiFunc<? super T, ? super T, ? extends T> reduce) {
        this((BiFunc<? extends T, ? extends T, ? extends T>)reduce, (Iterable<Scalar<? extends T>>)new Mapped<Constant>(Constant::new, values));
    }

    public Reduced(BiFunc<? super T, ? super T, ? extends T> reduce, Iterable<? extends Scalar<? extends T>> scalars) {
        this.items = scalars;
        this.function = reduce;
    }

    @Override
    public T value() throws Exception {
        Iterator<Scalar<T>> iter = this.items.iterator();
        if (!iter.hasNext()) {
            throw new NoSuchElementException("Can't find first element in an empty iterable");
        }
        T acc = iter.next().value();
        while (iter.hasNext()) {
            T next = iter.next().value();
            acc = this.function.apply(acc, next);
        }
        return acc;
    }
}

