/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import java.time.Duration;
import org.cactoos.Func;
import org.cactoos.Scalar;

public final class Retry<T>
implements Scalar<T> {
    private final Scalar<? extends T> origin;
    private final Func<Integer, Boolean> func;
    private final Duration wait;

    public Retry(Scalar<? extends T> scalar) {
        this(scalar, Duration.ZERO);
    }

    public Retry(Scalar<? extends T> scalar, Duration wait) {
        this(scalar, 3, wait);
    }

    public Retry(Scalar<? extends T> scalar, int attempts) {
        this(scalar, attempts, Duration.ZERO);
    }

    public Retry(Scalar<? extends T> scalar, int attempts, Duration wait) {
        this(scalar, attempt -> attempt >= attempts, wait);
    }

    public Retry(Scalar<? extends T> scalar, Func<Integer, Boolean> exit) {
        this(scalar, exit, Duration.ZERO);
    }

    public Retry(Scalar<? extends T> scalar, Func<Integer, Boolean> exit, Duration wait) {
        this.origin = scalar;
        this.func = exit;
        this.wait = wait;
    }

    @Override
    public T value() throws Exception {
        return (T)new org.cactoos.func.Retry<Boolean, Object>(input -> this.origin.value(), this.func, this.wait).apply(true);
    }
}

