/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.scalar;

import java.util.Comparator;
import java.util.Map;
import org.cactoos.Fallback;
import org.cactoos.Scalar;
import org.cactoos.func.Flattened;
import org.cactoos.iterable.IterableOf;
import org.cactoos.iterator.Filtered;
import org.cactoos.iterator.Sorted;
import org.cactoos.map.MapOf;
import org.cactoos.scalar.Constant;
import org.cactoos.scalar.Equals;
import org.cactoos.scalar.Not;

public final class ScalarWithFallback<T>
implements Scalar<T> {
    private final Scalar<? extends T> origin;
    private final Iterable<? extends Fallback<? extends T>> fallbacks;

    @SafeVarargs
    public ScalarWithFallback(Scalar<? extends T> origin, Fallback<? extends T> ... fbks) {
        this(origin, new IterableOf<Fallback<? extends T>>(fbks));
    }

    public ScalarWithFallback(Scalar<? extends T> origin, Iterable<? extends Fallback<? extends T>> fbks) {
        this.origin = origin;
        this.fallbacks = fbks;
    }

    @Override
    public T value() throws Exception {
        T result;
        try {
            result = this.origin.value();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            result = this.fallback(ex);
        }
        catch (Throwable ex) {
            result = this.fallback(ex);
        }
        return result;
    }

    private T fallback(Throwable exp) throws Exception {
        Sorted candidates = new Sorted(Comparator.comparing(Map.Entry::getValue), new Filtered(new Flattened(entry -> new Not(new Equals<Integer, Integer>(entry::getValue, new Constant<Integer>(Integer.MIN_VALUE)))), new MapOf<Fallback, Integer>(fbk -> fbk, fbk -> fbk.support(exp), this.fallbacks).entrySet().iterator()));
        if (candidates.hasNext()) {
            return (T)((Fallback)((Map.Entry)candidates.next()).getKey()).apply(exp);
        }
        throw new Exception("No fallback found - throw the original exception", exp);
    }
}

