/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.text;

import java.io.IOException;
import org.cactoos.Func;
import org.cactoos.Text;
import org.cactoos.func.UncheckedFunc;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;

public final class IoCheckedText
implements Text {
    private final Text text;
    private final Func<Exception, String> fallback;

    public IoCheckedText(CharSequence txt) {
        this(new TextOf(txt));
    }

    public IoCheckedText(Text txt) {
        this(txt, error -> {
            throw new RuntimeException((Throwable)error);
        });
    }

    public IoCheckedText(Text txt, Func<Exception, String> fbk) {
        this.text = txt;
        this.fallback = fbk;
    }

    @Override
    public String asString() throws IOException {
        String txt;
        try {
            txt = this.text.asString();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            txt = new UncheckedFunc<Exception, String>(this.fallback).apply(ex);
        }
        return txt;
    }

    public String toString() {
        return new UncheckedText(this).toString();
    }

    public boolean equals(Object obj) {
        return new UncheckedText(this).equals(obj);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

