/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.text;

import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import org.cactoos.Scalar;
import org.cactoos.iterable.RangeOf;
import org.cactoos.list.ListOf;
import org.cactoos.text.TextEnvelope;
import org.cactoos.text.TextOf;

public final class Randomized
extends TextEnvelope {
    private static final int MAX_RANDOM_LENGTH = 255;

    public Randomized() {
        this(() -> new SecureRandom().nextInt(254) + 1);
    }

    public Randomized(Integer len) {
        this(() -> len);
    }

    public Randomized(Scalar<Integer> len) {
        this(new RangeOf<Character>(Character.valueOf('!'), Character.valueOf('~'), ch -> {
            ch = Character.valueOf((char)(ch.charValue() + '\u0001'));
            return ch;
        }), len);
    }

    public Randomized(Character ... chrs) {
        this(new ListOf<Character>(chrs));
    }

    public Randomized(List<Character> chrs) {
        this(chrs, () -> new SecureRandom().nextInt(254) + 1);
    }

    public Randomized(Integer len, Character ... chrs) {
        this(() -> len, chrs);
    }

    public Randomized(Scalar<Integer> len, Character ... chrs) {
        this(new ListOf<Character>(chrs), len);
    }

    public Randomized(Iterable<Character> chrs, Scalar<Integer> len) {
        this(chrs, len, new SecureRandom());
    }

    public Randomized(Iterable<Character> itr, Scalar<Integer> len, Random rnd) {
        super(new TextOf(() -> {
            ListOf chrs = new ListOf(itr);
            int length = (Integer)len.value();
            StringBuilder builder = new StringBuilder(length);
            int bound = chrs.size();
            for (int index = 0; index < length; ++index) {
                builder.append(chrs.get(rnd.nextInt(bound)));
            }
            return builder.toString();
        }));
    }
}

