/*
 * Decompiled with CFR 0.152.
 */
package org.cactoos.text;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import org.cactoos.text.TextEnvelope;
import org.cactoos.text.TextOfScalar;
import org.cactoos.time.Iso;

public final class TextOfDateTime
extends TextEnvelope {
    public TextOfDateTime(LocalDate date) {
        this(new Iso().value(), date);
    }

    public TextOfDateTime(String format, LocalDate date) {
        this(format, date, Locale.getDefault(Locale.Category.FORMAT));
    }

    public TextOfDateTime(String format, LocalDate date, Locale locale) {
        this(DateTimeFormatter.ofPattern(format, locale), date);
    }

    public TextOfDateTime(LocalDateTime date) {
        this(new Iso().value(), date);
    }

    public TextOfDateTime(String format, LocalDateTime date) {
        this(format, date, Locale.getDefault(Locale.Category.FORMAT));
    }

    public TextOfDateTime(String format, LocalDateTime date, Locale locale) {
        this(DateTimeFormatter.ofPattern(format, locale), date);
    }

    public TextOfDateTime(Date date) {
        this(new Iso().value(), date);
    }

    public TextOfDateTime(String format, Date date) {
        this(format, date, Locale.getDefault(Locale.Category.FORMAT));
    }

    public TextOfDateTime(String format, Date date, Locale locale) {
        this(DateTimeFormatter.ofPattern(format, locale), date);
    }

    public TextOfDateTime(OffsetDateTime date) {
        this(new Iso().value(), date);
    }

    public TextOfDateTime(String format, OffsetDateTime date) {
        this(format, date, Locale.getDefault(Locale.Category.FORMAT));
    }

    public TextOfDateTime(String format, OffsetDateTime date, Locale locale) {
        this(DateTimeFormatter.ofPattern(format, locale), date);
    }

    public TextOfDateTime(ZonedDateTime date) {
        this(new Iso().value(), date);
    }

    public TextOfDateTime(String format, ZonedDateTime date) {
        this(format, date, Locale.getDefault(Locale.Category.FORMAT));
    }

    public TextOfDateTime(String format, ZonedDateTime date, Locale locale) {
        this(DateTimeFormatter.ofPattern(format, locale), date);
    }

    public TextOfDateTime(DateTimeFormatter formatter, LocalDate date) {
        super(new TextOfScalar(() -> formatter.format(ZonedDateTime.of(date, LocalTime.MIN, ZoneId.systemDefault()))));
    }

    public TextOfDateTime(DateTimeFormatter formatter, LocalDateTime date) {
        super(new TextOfScalar(() -> formatter.format(date.atZone(ZoneId.systemDefault()))));
    }

    public TextOfDateTime(DateTimeFormatter formatter, Date date) {
        super(new TextOfScalar(() -> formatter.format(ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()))));
    }

    public TextOfDateTime(DateTimeFormatter formatter, OffsetDateTime date) {
        super(new TextOfScalar(() -> formatter.format(date)));
    }

    public TextOfDateTime(DateTimeFormatter formatter, ZonedDateTime date) {
        super(new TextOfScalar(() -> formatter.format(date)));
    }
}

