/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.internal.storage.file.PackedBatchRefUpdate;
import org.eclipse.jgit.internal.storage.file.RefDirectory;
import org.eclipse.jgit.internal.storage.file.RefDirectoryRename;
import org.eclipse.jgit.internal.storage.file.RefDirectoryUpdate;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.revwalk.RevWalk;

class SnapshottingRefDirectory
extends RefDirectory {
    final RefDirectory refDb;
    private volatile boolean isValid;

    SnapshottingRefDirectory(RefDirectory refDb) {
        super(refDb);
        this.refDb = refDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    RefDirectory.PackedRefList getPackedRefs() throws IOException {
        if (!this.isValid) {
            SnapshottingRefDirectory snapshottingRefDirectory = this;
            synchronized (snapshottingRefDirectory) {
                if (!this.isValid) {
                    this.refreshSnapshot();
                }
            }
        }
        return (RefDirectory.PackedRefList)this.packedRefs.get();
    }

    @Override
    void delete(RefDirectoryUpdate update) throws IOException {
        this.refreshSnapshot();
        super.delete(update);
    }

    @Override
    public RefDirectoryUpdate newUpdate(String name, boolean detach) throws IOException {
        this.refreshSnapshot();
        return super.newUpdate(name, detach);
    }

    @Override
    public PackedBatchRefUpdate newBatchUpdate() {
        return new SnapshotPackedBatchRefUpdate(this);
    }

    @Override
    public PackedBatchRefUpdate newBatchUpdate(boolean shouldLockLooseRefs) {
        return new SnapshotPackedBatchRefUpdate(this, shouldLockLooseRefs);
    }

    @Override
    RefDirectoryUpdate newTemporaryUpdate() throws IOException {
        this.refreshSnapshot();
        return super.newTemporaryUpdate();
    }

    @Override
    RefDirectoryUpdate createRefDirectoryUpdate(Ref ref) {
        return new SnapshotRefDirectoryUpdate(this, ref);
    }

    @Override
    RefDirectoryRename createRefDirectoryRename(RefDirectoryUpdate from, RefDirectoryUpdate to) {
        return new SnapshotRefDirectoryRename(from, to);
    }

    synchronized void invalidateSnapshot() {
        this.isValid = false;
    }

    private synchronized void refreshSnapshot() throws IOException {
        this.compareAndSetPackedRefs((RefDirectory.PackedRefList)this.packedRefs.get(), this.refDb.getPackedRefs());
        this.isValid = true;
    }

    private static <T> T invalidateSnapshotOnError(SupplierThrowsException<T, IOException> f, RefDatabase refDb) throws IOException {
        return (T)SnapshottingRefDirectory.invalidateSnapshotOnError(a -> f.call(), null, refDb);
    }

    private static <A, R> R invalidateSnapshotOnError(FunctionThrowsException<A, R, IOException> f, A a, RefDatabase refDb) throws IOException {
        try {
            return f.apply(a);
        }
        catch (IOException e) {
            ((SnapshottingRefDirectory)refDb).invalidateSnapshot();
            throw e;
        }
    }

    private static <A1, A2, A3> void invalidateSnapshotOnError(TriConsumerThrowsException<A1, A2, A3, IOException> f, A1 a1, A2 a2, A3 a3, RefDatabase refDb) throws IOException {
        try {
            f.accept(a1, a2, a3);
        }
        catch (IOException e) {
            ((SnapshottingRefDirectory)refDb).invalidateSnapshot();
            throw e;
        }
    }

    @FunctionalInterface
    private static interface FunctionThrowsException<A, R, E extends Exception> {
        public R apply(A var1) throws E;
    }

    private static class SnapshotPackedBatchRefUpdate
    extends PackedBatchRefUpdate {
        SnapshotPackedBatchRefUpdate(RefDirectory refdb) {
            super(refdb);
        }

        SnapshotPackedBatchRefUpdate(RefDirectory refdb, boolean shouldLockLooseRefs) {
            super(refdb, shouldLockLooseRefs);
        }

        @Override
        public void execute(RevWalk walk, ProgressMonitor monitor, List<String> options) throws IOException {
            SnapshottingRefDirectory.invalidateSnapshotOnError((rw, m4, o) -> super.execute((RevWalk)rw, (ProgressMonitor)m4, (List<String>)o), walk, monitor, options, this.getRefDatabase());
        }

        @Override
        public void execute(RevWalk walk, ProgressMonitor monitor) throws IOException {
            SnapshottingRefDirectory.invalidateSnapshotOnError((rw, m4, a3) -> super.execute((RevWalk)rw, (ProgressMonitor)m4), walk, monitor, null, this.getRefDatabase());
        }
    }

    private static class SnapshotRefDirectoryRename
    extends RefDirectoryRename {
        SnapshotRefDirectoryRename(RefDirectoryUpdate src, RefDirectoryUpdate dst) {
            super(src, dst);
        }

        @Override
        public RefUpdate.Result rename() throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(() -> super.rename(), this.getRefDirectory());
        }
    }

    private static class SnapshotRefDirectoryUpdate
    extends RefDirectoryUpdate {
        SnapshotRefDirectoryUpdate(RefDirectory r, Ref ref) {
            super(r, ref);
        }

        @Override
        public RefUpdate.Result forceUpdate() throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(() -> super.forceUpdate(), this.getRefDatabase());
        }

        @Override
        public RefUpdate.Result update() throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(() -> super.update(), this.getRefDatabase());
        }

        @Override
        public RefUpdate.Result update(RevWalk walk) throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(rw -> super.update((RevWalk)rw), walk, this.getRefDatabase());
        }

        @Override
        public RefUpdate.Result delete() throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(() -> super.delete(), this.getRefDatabase());
        }

        @Override
        public RefUpdate.Result delete(RevWalk walk) throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(rw -> super.delete((RevWalk)rw), walk, this.getRefDatabase());
        }

        @Override
        public RefUpdate.Result link(String target) throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(t2 -> super.link((String)t2), target, this.getRefDatabase());
        }
    }

    @FunctionalInterface
    private static interface SupplierThrowsException<R, E extends Exception> {
        public R call() throws E;
    }

    @FunctionalInterface
    private static interface TriConsumerThrowsException<A1, A2, A3, E extends Exception> {
        public void accept(A1 var1, A2 var2, A3 var3) throws E;
    }
}

