/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import jakarta.json.bind.JsonbException;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.yasson.internal.ResolvedParameterizedType;
import org.eclipse.yasson.internal.VariableTypeInheritanceSearch;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class ReflectionUtils {
    private static final Logger LOGGER = Logger.getLogger(ReflectionUtils.class.getName());

    private ReflectionUtils() {
        throw new IllegalStateException("Utility classes should not be instantiated.");
    }

    public static Optional<Class<?>> getOptionalRawType(Type type) {
        TypeVariable typeVariable;
        if (type instanceof Class) {
            return Optional.of((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return Optional.of((Class)((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Optional.of(((GenericArrayType)type).getClass());
        }
        if (type instanceof TypeVariable && Objects.nonNull((typeVariable = (TypeVariable)TypeVariable.class.cast(type)).getBounds())) {
            Optional<Class<?>> specializedClass = Optional.empty();
            for (Type bound : typeVariable.getBounds()) {
                Optional<Class<?>> boundRawType = ReflectionUtils.getOptionalRawType(bound);
                if (!boundRawType.isPresent() || Object.class.equals(boundRawType.get()) || specializedClass.isPresent() && !specializedClass.get().isAssignableFrom(boundRawType.get())) continue;
                specializedClass = Optional.of(boundRawType.get());
            }
            return specializedClass;
        }
        return Optional.empty();
    }

    public static Class<?> getRawType(Type type) {
        return ReflectionUtils.getOptionalRawType(type).orElseThrow(() -> new JsonbException(Messages.getMessage(MessageKeys.TYPE_RESOLUTION_ERROR, type)));
    }

    public static Class<?> resolveRawType(List<Type> chain, Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return ReflectionUtils.getRawType(ReflectionUtils.resolveType(chain, type));
    }

    public static Type resolveType(List<Type> chain, Type type) {
        return ReflectionUtils.resolveType(chain, type, true);
    }

    private static Type resolveType(List<Type> chain, Type type, boolean warn) {
        Type toResolve = type;
        if (type instanceof GenericArrayType) {
            toResolve = ((GenericArrayType)type).getGenericComponentType();
            Type resolved = ReflectionUtils.resolveType(chain, toResolve);
            return new GenericArrayTypeImpl(resolved);
        }
        if (toResolve instanceof WildcardType) {
            return ReflectionUtils.resolveMostSpecificBound(chain, (WildcardType)toResolve, warn);
        }
        if (toResolve instanceof TypeVariable) {
            return ReflectionUtils.resolveItemVariableType(chain, (TypeVariable)toResolve, warn);
        }
        if (toResolve instanceof ParameterizedType) {
            return ReflectionUtils.resolveTypeArguments((ParameterizedType)toResolve, chain.get(chain.size() - 1));
        }
        return type;
    }

    public static Optional<Type> resolveOptionalType(List<Type> chain, Type type) {
        try {
            return Optional.of(ReflectionUtils.resolveType(chain, type, false));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    public static Type resolveItemVariableType(List<Type> chain, TypeVariable<?> typeVariable, boolean warn) {
        Type returnType = typeVariable;
        for (int i = chain.size() - 1; i >= 0; --i) {
            Type type = chain.get(i);
            Type tmp = new VariableTypeInheritanceSearch().searchParametrizedType(type, (TypeVariable<?>)returnType);
            if (tmp != null) {
                returnType = tmp;
            }
            if (!(returnType instanceof TypeVariable)) break;
        }
        if (returnType instanceof TypeVariable) {
            return Object.class;
        }
        return returnType;
    }

    public static Type resolveTypeArguments(ParameterizedType typeToResolve, Type typeToSearch) {
        Object[] unresolvedArgs = typeToResolve.getActualTypeArguments();
        Object[] resolvedArgs = new Type[unresolvedArgs.length];
        for (int i = 0; i < unresolvedArgs.length; ++i) {
            Type unresolvedArg = unresolvedArgs[i];
            if (!(unresolvedArg instanceof TypeVariable) && !(unresolvedArg instanceof GenericArrayType)) {
                resolvedArgs[i] = unresolvedArg;
            } else {
                Type variableType = unresolvedArg;
                if (variableType instanceof GenericArrayType) {
                    variableType = ((GenericArrayType)variableType).getGenericComponentType();
                }
                resolvedArgs[i] = new VariableTypeInheritanceSearch().searchParametrizedType(typeToSearch, (TypeVariable)variableType);
                if (resolvedArgs[i] == null) {
                    if (typeToSearch instanceof Class) {
                        return Object.class;
                    }
                    throw new IllegalStateException(Messages.getMessage(MessageKeys.GENERIC_BOUND_NOT_FOUND, variableType, typeToSearch));
                }
            }
            if (resolvedArgs[i] instanceof ParameterizedType) {
                resolvedArgs[i] = ReflectionUtils.resolveTypeArguments((ParameterizedType)resolvedArgs[i], typeToSearch);
                continue;
            }
            if (!(unresolvedArg instanceof GenericArrayType)) continue;
            resolvedArgs[i] = new GenericArrayTypeImpl((Type)resolvedArgs[i]);
        }
        return Arrays.equals(resolvedArgs, unresolvedArgs) ? typeToResolve : new ResolvedParameterizedType(typeToResolve, (Type[])resolvedArgs);
    }

    public static <T> T createNoArgConstructorInstance(Constructor<T> constructor) {
        Objects.requireNonNull(constructor);
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JsonbException("Can't create instance", e);
        }
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> clazz, boolean required) {
        Objects.requireNonNull(clazz);
        return AccessController.doPrivileged(() -> {
            try {
                Constructor declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
                if (declaredConstructor.getModifiers() == 4) {
                    declaredConstructor.setAccessible(true);
                }
                return declaredConstructor;
            }
            catch (NoSuchMethodException | RuntimeException e) {
                if (required) {
                    throw new JsonbException(Messages.getMessage(MessageKeys.NO_DEFAULT_CONSTRUCTOR, clazz), e);
                }
                return null;
            }
        });
    }

    public static ParameterizedType findParameterizedType(Class<?> classToSearch, Class<?> parameterizedInterface) {
        for (Class<?> current = classToSearch; current != Object.class; current = current.getSuperclass()) {
            for (Type currentInterface : current.getGenericInterfaces()) {
                if (!(currentInterface instanceof ParameterizedType) || !parameterizedInterface.isAssignableFrom(ReflectionUtils.getRawType(((ParameterizedType)currentInterface).getRawType()))) continue;
                return (ParameterizedType)currentInterface;
            }
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.NON_PARAMETRIZED_TYPE, parameterizedInterface));
    }

    public static boolean isResolvedType(Type type) {
        if (type instanceof ParameterizedType) {
            for (Type typeArg : ((ParameterizedType)type).getActualTypeArguments()) {
                if (ReflectionUtils.isResolvedType(typeArg)) continue;
                return false;
            }
            return true;
        }
        return type instanceof Class;
    }

    private static ParameterizedType findParameterizedSuperclass(Type type) {
        if (type == null || type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        if (!(type instanceof Class)) {
            throw new JsonbException("Can't resolve ParameterizedType superclass for: " + type);
        }
        return ReflectionUtils.findParameterizedSuperclass(((Class)type).getGenericSuperclass());
    }

    private static Type resolveMostSpecificBound(List<Type> chain, WildcardType wildcardType, boolean warn) {
        Class result = Object.class;
        for (Type upperBound : wildcardType.getUpperBounds()) {
            result = ReflectionUtils.getMostSpecificBound(chain, result, upperBound, warn);
        }
        for (Type lowerBound : wildcardType.getLowerBounds()) {
            result = ReflectionUtils.getMostSpecificBound(chain, result, lowerBound, warn);
        }
        return result;
    }

    private static Class<?> getMostSpecificBound(List<Type> chain, Class<?> result, Type bound, boolean warn) {
        if (bound == Object.class) {
            return result;
        }
        Type resolvedBoundType = bound instanceof TypeVariable ? ReflectionUtils.resolveType(chain, bound, warn) : bound;
        Class<?> boundRawType = ReflectionUtils.getRawType(resolvedBoundType);
        if (result.isAssignableFrom(boundRawType)) {
            result = boundRawType;
        }
        return result;
    }

    public static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type genericComponentType;

        private GenericArrayTypeImpl(Type ct) {
            this.genericComponentType = ct;
        }

        @Override
        public Type getGenericComponentType() {
            return this.genericComponentType;
        }

        public String toString() {
            return this.getGenericComponentType().getTypeName() + "[]";
        }

        public boolean equals(Object o) {
            if (o instanceof GenericArrayType) {
                GenericArrayType that = (GenericArrayType)o;
                return Objects.equals(this.genericComponentType, that.getGenericComponentType());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.genericComponentType);
        }
    }
}

