/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.OsCheck;
import com.exasol.projectkeeper.shared.mavenprojectcrawler.MavenProjectCrawlResult;
import com.exasol.projectkeeper.shared.mavenprojectcrawler.ResponseCoder;
import com.exasol.projectkeeper.stream.AsyncStreamReader;
import com.exasol.projectkeeper.stream.CollectingConsumer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class JavaProjectCrawlerRunner {
    private static final Logger LOGGER = Logger.getLogger(JavaProjectCrawlerRunner.class.getName());
    private static final Duration STREAM_READING_TIMEOUT = Duration.ofSeconds(1L);
    private final Path mvnRepositoryOverride;
    private final String ownVersion;

    public JavaProjectCrawlerRunner(Path mvnRepositoryOverride, String ownVersion) {
        this.mvnRepositoryOverride = mvnRepositoryOverride;
        this.ownVersion = ownVersion;
    }

    public MavenProjectCrawlResult crawlProject(Path ... pomFiles) {
        String json = this.runCrawlerPlugin(pomFiles);
        return MavenProjectCrawlResult.fromJson((String)json);
    }

    private String runCrawlerPlugin(Path ... pomFiles) {
        String projectList = Arrays.stream(pomFiles).map(pomFile -> pomFile.toAbsolutePath().toString().replace(FileSystems.getDefault().getSeparator(), "/")).collect(Collectors.joining(";"));
        try {
            ArrayList<String> commandParts = new ArrayList<String>(List.of(this.getMavenExecutable(), "--batch-mode", "-Dorg.slf4j.simpleLogger.log.org.apache.maven.cli.transfer.Slf4jMavenTransferListener=warn", "com.exasol:project-keeper-java-project-crawler:" + this.ownVersion + ":crawl", "-DprojectsToCrawl=" + projectList, "-Dmaven.defaultProjectBuilder.disableGlobalModelCache=true"));
            if (this.mvnRepositoryOverride != null) {
                commandParts.add("-Dmaven.repo.local=" + this.mvnRepositoryOverride);
            }
            LOGGER.fine(() -> "Executing command " + commandParts);
            Process proc = new ProcessBuilder(commandParts).redirectErrorStream(true).start();
            CollectingConsumer streamConsumer = new AsyncStreamReader().startCollectingConsumer(proc.getInputStream());
            if (!proc.waitFor(90L, TimeUnit.SECONDS)) {
                String output = streamConsumer.getContent(STREAM_READING_TIMEOUT);
                throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-81").message("Timeout while executing command {{executed command|u}}. Output was {{output}}", new Object[]{commandParts, output}).toString());
            }
            int exitCode = proc.exitValue();
            String output = streamConsumer.getContent(STREAM_READING_TIMEOUT);
            if (exitCode != 0) {
                LOGGER.log(Level.SEVERE, output);
                throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-78").message("Failed to run command {{executed command|u}}, exit code was {{exit code}}. Output:\n{{output}}", new Object[]{commandParts, exitCode, output}).toString());
            }
            return new ResponseCoder().decodeResponse(output);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(this.getRunFailedMessage(), exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(this.getRunFailedMessage(), exception);
        }
    }

    private String getMavenExecutable() {
        OsCheck.OSType osType = new OsCheck().getOperatingSystemType();
        if (osType == OsCheck.OSType.WINDOWS) {
            return "mvn.cmd";
        }
        return "mvn";
    }

    private String getRunFailedMessage() {
        return ExaError.messageBuilder((String)"E-PK-CORE-80").message("Failed to run project-keeper-java-project-crawler.", new Object[0]).toString();
    }
}

