/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.ApStyleFormatter;
import com.exasol.projectkeeper.BrokenLinkReplacer;
import com.exasol.projectkeeper.LicenseNameReader;
import com.exasol.projectkeeper.Logger;
import com.exasol.projectkeeper.ProjectVersionDetector;
import com.exasol.projectkeeper.RepoInfo;
import com.exasol.projectkeeper.ValidationPhase;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.config.ProjectKeeperConfigReader;
import com.exasol.projectkeeper.shared.config.ProjectKeeperConfig;
import com.exasol.projectkeeper.shared.config.Source;
import com.exasol.projectkeeper.shared.config.SourceType;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.sources.SourceAnalyzer;
import com.exasol.projectkeeper.sources.analyze.generic.RepoNameReader;
import com.exasol.projectkeeper.validators.DeletedFilesValidator;
import com.exasol.projectkeeper.validators.GitignoreFileValidator;
import com.exasol.projectkeeper.validators.LicenseFileValidator;
import com.exasol.projectkeeper.validators.OwnVersionValidator;
import com.exasol.projectkeeper.validators.ReadmeFileValidator;
import com.exasol.projectkeeper.validators.changelog.ChangelogFileValidator;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileValidator;
import com.exasol.projectkeeper.validators.dependencies.DependenciesValidator;
import com.exasol.projectkeeper.validators.files.LatestChangesFileValidator;
import com.exasol.projectkeeper.validators.files.ProjectFilesValidator;
import com.exasol.projectkeeper.validators.finding.FindingFilter;
import com.exasol.projectkeeper.validators.finding.FindingsFixer;
import com.exasol.projectkeeper.validators.finding.FindingsUngrouper;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import com.exasol.projectkeeper.validators.pom.PomFileValidator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ProjectKeeper {
    private static final String INVALID_STRUCTURE_MESSAGE = "This projects structure does not conform with the template.";
    private final Logger logger;
    private final Path projectDir;
    private final Path mvnRepo;
    private final ProjectKeeperConfig config;
    private final String ownVersion;
    private final String repoName;

    private ProjectKeeper(Logger logger, Path projectDir, Path mvnRepo, ProjectKeeperConfig config, String ownVersion) {
        this.logger = logger;
        this.projectDir = projectDir;
        this.mvnRepo = mvnRepo;
        this.config = config;
        this.ownVersion = ownVersion;
        this.repoName = RepoNameReader.getRepoName(projectDir);
    }

    public static ProjectKeeper createProjectKeeper(Logger logger, Path projectDir, Path mvnRepo) {
        return new ProjectKeeper(logger, projectDir, mvnRepo, ProjectKeeper.readConfig(projectDir), ProjectKeeper.getOwnVersion());
    }

    private static String getOwnVersion() {
        String packageVersion = ProjectKeeper.class.getPackage().getImplementationVersion();
        if (packageVersion != null) {
            return packageVersion;
        }
        String versionFromProperty = System.getProperty("com.exasol.projectkeeper.ownVersion");
        if (versionFromProperty != null) {
            return versionFromProperty;
        }
        return "(unknownVersion)";
    }

    static ProjectKeeper createProjectKeeper(Logger logger, Path projectDir, Path mvnRepo, String ownVersion) {
        return new ProjectKeeper(logger, projectDir, mvnRepo, ProjectKeeper.readConfig(projectDir), ownVersion);
    }

    private List<Function<ValidationPhase.Provision, ValidationPhase>> getValidationPhases() {
        return List.of(this::phase0, this::phase1, this::phase2, this::phase3);
    }

    private ValidationPhase phase0(ValidationPhase.Provision provision) {
        return ValidationPhase.from(new LicenseFileValidator(this.projectDir));
    }

    private ValidationPhase phase1(ValidationPhase.Provision provision) {
        String licenseName = new LicenseNameReader().readLicenseName(this.projectDir);
        ArrayList<Validator> validators = new ArrayList<Validator>();
        for (Source source : this.config.getSources()) {
            if (source.getType().equals((Object)SourceType.MAVEN)) {
                validators.add(new PomFileValidator(this.projectDir, source.getModules(), source.getPath(), source.getParentPom(), new RepoInfo(this.repoName, licenseName)));
                continue;
            }
            validators.add(OwnVersionValidator.forCli(this.ownVersion));
        }
        return new ValidationPhase(null, validators);
    }

    private ValidationPhase phase2(ValidationPhase.Provision provision) {
        List sources = this.config.getSources();
        List<AnalyzedSource> analyzedSources = SourceAnalyzer.create(this.config, this.mvnRepo, this.ownVersion).analyze(this.projectDir, sources);
        String projectName = this.getProjectName(analyzedSources);
        BrokenLinkReplacer brokenLinkReplacer = new BrokenLinkReplacer(this.config.getLinkReplacements());
        String projectVersion = new ProjectVersionDetector().detectVersion(this.config, analyzedSources);
        ProjectFilesValidator projectFilesValidator = ProjectFilesValidator.builder().projectDirectory(this.projectDir).analyzedSources(analyzedSources).logger(this.logger).projectKeeperVersion(this.ownVersion).hasNpmModule(this.hasSourceOfType(sources, SourceType.NPM)).ciBuildOptions(this.config.getCiBuildConfig()).build();
        List<Validator> validators = List.of(projectFilesValidator, new ReadmeFileValidator(this.projectDir, projectName, this.repoName, analyzedSources), new ChangesFileValidator(projectVersion, projectName, this.projectDir, analyzedSources), new DependenciesValidator(analyzedSources, this.projectDir, brokenLinkReplacer), new DeletedFilesValidator(this.projectDir), new GitignoreFileValidator(this.projectDir));
        return new ValidationPhase(new ValidationPhase.Provision(projectVersion), validators);
    }

    private boolean hasSourceOfType(List<Source> sources, SourceType type) {
        return sources.stream().map(Source::getType).anyMatch(arg_0 -> type.equals(arg_0));
    }

    private ValidationPhase phase3(ValidationPhase.Provision provision) {
        List<Validator> validators = List.of(new LatestChangesFileValidator(this.projectDir, provision.projectVersion()), new ChangelogFileValidator(this.projectDir));
        return new ValidationPhase(provision, validators);
    }

    private String getProjectName(List<AnalyzedSource> analyzedSources) {
        return ApStyleFormatter.humanReadable(analyzedSources.size() == 1 ? analyzedSources.get(0).getProjectName() : this.repoName);
    }

    private static ProjectKeeperConfig readConfig(Path projectDir) {
        return new ProjectKeeperConfigReader().readConfig(projectDir);
    }

    public boolean verify() {
        return this.runValidationPhases(this::handleVerifyFindings);
    }

    private boolean handleVerifyFindings(List<ValidationFinding> findings) {
        List<SimpleValidationFinding> findingsFlat = new FindingsUngrouper().ungroupFindings(findings);
        findingsFlat.forEach(this::reportFinding);
        boolean hasFindingsWithFix = findingsFlat.stream().anyMatch(SimpleValidationFinding::hasFix);
        boolean hasFindingsWithoutFix = findingsFlat.stream().anyMatch(finding -> !finding.hasFix());
        this.logValidationFailure(hasFindingsWithFix, hasFindingsWithoutFix);
        return SimpleValidationFinding.blockers(findingsFlat).isEmpty();
    }

    private void reportFinding(SimpleValidationFinding finding) {
        if (finding.isOptional()) {
            this.logger.warn(finding.getMessage());
        } else {
            this.logger.error(finding.getMessage());
        }
    }

    private void logValidationFailure(boolean hasFindingsWithFix, boolean hasFindingsWithoutFix) {
        if (hasFindingsWithoutFix && hasFindingsWithFix) {
            this.logger.error(ExaError.messageBuilder((String)"E-PK-CORE-24").message(INVALID_STRUCTURE_MESSAGE, new Object[0]).mitigation("You can automatically fix some of the issues by running mvn project-keeper:fix but some also need to be fixed manually.", new Object[0]).toString());
        } else if (hasFindingsWithFix) {
            this.logger.error(ExaError.messageBuilder((String)"E-PK-CORE-6").message(INVALID_STRUCTURE_MESSAGE, new Object[0]).mitigation("Run mvn project-keeper:fix to fix the issues automatically.", new Object[0]).toString());
        } else if (hasFindingsWithoutFix) {
            this.logger.error(ExaError.messageBuilder((String)"E-PK-CORE-25").message(INVALID_STRUCTURE_MESSAGE, new Object[0]).mitigation("Please fix it manually.", new Object[0]).toString());
        }
    }

    public boolean fix() {
        return this.runValidationPhases(this::fixFindings);
    }

    private boolean runValidationPhases(PhaseResultHandler phaseResultHandler) {
        ValidationPhase.Provision provision = null;
        for (Function<ValidationPhase.Provision, ValidationPhase> phaseSupplier : this.getValidationPhases()) {
            ValidationPhase phase = phaseSupplier.apply(provision);
            provision = phase.provision();
            List<ValidationFinding> findings = this.runValidation(phase.validators());
            if (phaseResultHandler.handlePhaseResult(findings)) continue;
            return false;
        }
        return true;
    }

    private List<ValidationFinding> runValidation(List<Validator> validators) {
        List<ValidationFinding> findings = validators.stream().flatMap(validator -> validator.validate().stream()).collect(Collectors.toList());
        return new FindingFilter(this.config.getExcludes()).filterFindings(findings);
    }

    private boolean fixFindings(List<ValidationFinding> findings) {
        ArrayList<SimpleValidationFinding> unfixedFindings = new ArrayList<SimpleValidationFinding>(new FindingsFixer(this.logger).fixFindings(findings));
        for (SimpleValidationFinding unfixedFinding : unfixedFindings) {
            this.logger.warn(ExaError.messageBuilder((String)"W-PK-CORE-67").message("Could not auto-fix: {{finding message|u}}", new Object[]{unfixedFinding.getMessage()}).toString());
        }
        if (SimpleValidationFinding.blockers(unfixedFindings).isEmpty()) {
            return true;
        }
        this.logger.error(ExaError.messageBuilder((String)"E-PK-CORE-65").message("PK could not fix all of the findings automatically. There are findings that you need to fix by hand.", new Object[0]).toString());
        return false;
    }

    @FunctionalInterface
    private static interface PhaseResultHandler {
        public boolean handlePhaseResult(List<ValidationFinding> var1);
    }
}

