/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.config;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.config.ProjectKeeperRawConfig;
import com.exasol.projectkeeper.shared.config.BuildOptions;
import com.exasol.projectkeeper.shared.config.FixedVersion;
import com.exasol.projectkeeper.shared.config.ParentPomRef;
import com.exasol.projectkeeper.shared.config.ProjectKeeperConfig;
import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.shared.config.Source;
import com.exasol.projectkeeper.shared.config.SourceType;
import com.exasol.projectkeeper.shared.config.VersionConfig;
import com.exasol.projectkeeper.shared.config.VersionFromSource;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class ProjectKeeperConfigReader {
    public static final String CONFIG_FILE_NAME = ".project-keeper.yml";
    private static final String USER_GUIDE_URL = "https://github.com/exasol/project-keeper-maven-plugin";
    private static final String CHECK_THE_USER_GUIDE = "Please check the user-guide https://github.com/exasol/project-keeper-maven-plugin.";
    private static final String INVALID_CONFIG_FILE = "Invalid .project-keeper.yml.";

    public ProjectKeeperConfig readConfig(Path projectDirectory) {
        ProjectKeeperConfig projectKeeperConfig;
        this.verifyWeReInProjectRoot(projectDirectory);
        Path configFile = projectDirectory.resolve(CONFIG_FILE_NAME);
        this.validateConfigFileExists(configFile);
        FileReader fileReader = new FileReader(configFile.toFile());
        try {
            ProjectKeeperRawConfig rawConfig = this.readRawConfig(fileReader, configFile);
            projectKeeperConfig = this.parseRawConfig(rawConfig, projectDirectory);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-82").message("Failed to read '.project-keeper.yml'.", new Object[0]).toString(), exception);
            }
        }
        fileReader.close();
        return projectKeeperConfig;
    }

    private void verifyWeReInProjectRoot(Path projectDirectory) {
        if (!Files.exists(projectDirectory.resolve(".git"), new LinkOption[0])) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-CORE-90").message("Could not find .git directory in project-root {{root path}}.", new Object[]{projectDirectory}).mitigation("Run 'git init'.", new Object[0]).mitigation("Make sure that you run project-keeper only in the root directory of the git-repository. If you have multiple projects in that directory, define them in the '.project-keeper.yml'.", new Object[0]).toString());
        }
    }

    private ProjectKeeperRawConfig readRawConfig(FileReader fileReader, Path path) {
        try {
            return (ProjectKeeperRawConfig)new Yaml().loadAs((Reader)fileReader, ProjectKeeperRawConfig.class);
        }
        catch (YAMLException exception) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-CORE-85").message("Invalid .project-keeper.yml. Path: {{path}}", new Object[]{path}).mitigation(CHECK_THE_USER_GUIDE, new Object[0]).toString(), exception);
        }
    }

    private void validateConfigFileExists(Path configFile) {
        if (!Files.exists(configFile, new LinkOption[0])) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-CORE-89").message("Could not find '.project-keeper.yml'.", new Object[0]).mitigation("Please create this configuration according to the user-guide https://github.com/exasol/project-keeper-maven-plugin.", new Object[0]).toString());
        }
    }

    private ProjectKeeperConfig parseRawConfig(ProjectKeeperRawConfig rawConfig, Path projectDir) {
        List<ProjectKeeperRawConfig.Source> rawSources = rawConfig.getSources();
        List<Source> sources = this.convertSources(projectDir, rawSources);
        List<String> excludes = this.convertExcludes(rawConfig.getExcludes());
        List linkReplacements = Objects.requireNonNullElseGet(rawConfig.getLinkReplacements(), Collections::emptyList);
        return ProjectKeeperConfig.builder().sources(sources).linkReplacements(linkReplacements).excludes(excludes).versionConfig(this.parseVersion(rawConfig.getVersion(), projectDir)).buildOptions(this.convertBuildOptions(rawConfig.getBuild())).build();
    }

    private VersionConfig parseVersion(Object rawVersion, Path projectDir) {
        Object fromMvnSource;
        if (rawVersion == null) {
            return null;
        }
        if (rawVersion instanceof String) {
            return new FixedVersion((String)rawVersion);
        }
        if (rawVersion instanceof Map && (fromMvnSource = ((Map)rawVersion).get("fromSource")) instanceof String) {
            return new VersionFromSource(projectDir.resolve(Path.of((String)fromMvnSource, new String[0])));
        }
        throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-CORE-113").message("Invalid .project-keeper.yml. Invalid value from property 'version'.", new Object[0]).mitigation("You can either set a version as string or tell PK from which maven source to read the version from with 'fromSource: \"path to project file to read version from\"'.", new Object[0]).toString());
    }

    private BuildOptions convertBuildOptions(ProjectKeeperRawConfig.Build build) {
        if (build == null) {
            return BuildOptions.builder().build();
        }
        return BuildOptions.builder().runnerOs(build.getRunnerOs()).freeDiskSpace(build.shouldFreeDiskSpace()).exasolDbVersions(build.getExasolDbVersions()).build();
    }

    private List<String> convertExcludes(List<Object> rawExcludes) {
        if (rawExcludes == null) {
            return Collections.emptyList();
        }
        ArrayList<String> excludes = new ArrayList<String>(rawExcludes.size());
        for (Object rawExclude : rawExcludes) {
            excludes.add(this.convertExclude(rawExclude));
        }
        return excludes;
    }

    private String convertExclude(Object rawExclude) {
        try {
            if (rawExclude instanceof String) {
                return Pattern.quote((String)rawExclude);
            }
            Map excludeMap = (Map)rawExclude;
            return (String)Objects.requireNonNull(excludeMap.get("regex"));
        }
        catch (ClassCastException | NullPointerException exception) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-CORE-87").message("Invalid .project-keeper.yml. Invalid value {{value}} for property 'excludes'.", new Object[]{rawExclude}).mitigation("Please use either a string or 'regex: \"my-regx\"'.", new Object[0]).mitigation(CHECK_THE_USER_GUIDE, new Object[0]).toString());
        }
    }

    private List<Source> convertSources(Path projectDir, List<ProjectKeeperRawConfig.Source> rawSources) {
        if (rawSources == null) {
            return Collections.emptyList();
        }
        ArrayList<Source> sources = new ArrayList<Source>(rawSources.size());
        for (ProjectKeeperRawConfig.Source rawSource : rawSources) {
            Source source = this.convertSource(projectDir, rawSource);
            sources.add(source);
        }
        return sources;
    }

    private Source convertSource(Path projectDir, ProjectKeeperRawConfig.Source rawSource) {
        String rawType = rawSource.getType();
        Set<ProjectKeeperModule> modules = this.convertModules(rawSource.getModules());
        Path path = this.convertPath(projectDir, rawSource.getPath());
        return Source.builder().path(path).type(this.convertType(rawType)).modules(modules).advertise(rawSource.isAdvertised()).parentPom(this.parseParentPomProperty(rawSource.getParentPom())).build();
    }

    private ParentPomRef parseParentPomProperty(ProjectKeeperRawConfig.ParentPomRef rawParentPomRef) {
        if (rawParentPomRef == null) {
            return null;
        }
        return new ParentPomRef(rawParentPomRef.getGroupId(), rawParentPomRef.getArtifactId(), rawParentPomRef.getVersion(), rawParentPomRef.getRelativePath());
    }

    private Set<ProjectKeeperModule> convertModules(List<String> rawModules) {
        if (rawModules == null) {
            return Set.of(ProjectKeeperModule.DEFAULT);
        }
        HashSet<ProjectKeeperModule> modules = new HashSet<ProjectKeeperModule>(rawModules.size() + 1);
        for (String rawModule : rawModules) {
            modules.add(ProjectKeeperModule.getModuleByName((String)rawModule));
        }
        modules.add(ProjectKeeperModule.DEFAULT);
        return modules;
    }

    private Path convertPath(Path projectDir, String rawPath) {
        this.requireProperty(rawPath, "sources/path");
        Path path = projectDir.resolve(rawPath);
        this.validatePathExists(path);
        return path;
    }

    private void requireProperty(Object propertyValue, String propertyName) {
        if (propertyValue == null) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-CORE-86").message("Invalid .project-keeper.yml. Missing required property {{property name}}.", new Object[]{propertyName}).toString());
        }
    }

    private void validatePathExists(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-CORE-83").message("Invalid .project-keeper.yml. The specified path {{path}} does not exist in the project directory.", new Object[]{path}).toString());
        }
    }

    private SourceType convertType(String rawType) {
        this.requireProperty(rawType, "sources/type");
        try {
            return SourceType.valueOf((String)rawType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException exception) {
            String supportedTypes = Arrays.stream(SourceType.values()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-CORE-84").message("Invalid .project-keeper.yml. Unsupported source type {{type}}.", new Object[]{rawType}).mitigation("Please use one of the supported types: {{supported types|u}}.", new Object[]{supportedTypes}).toString());
        }
    }
}

