/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.mavenrepo;

import com.exasol.projectkeeper.xpath.XPathErrorHandlingWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class MavenRepository {
    static final String BASE_URL = "https://repo1.maven.org/maven2/";
    static final String METADATA_FILE = "/maven-metadata.xml";
    private static final String PROJECT_KEEPER_PREFIX = "com/exasol/project-keeper-";
    private static final String LATEST_VERSION_XPATH = "/metadata/versioning/latest";
    private final String url;

    public static MavenRepository projectKeeperCli() {
        return MavenRepository.of("com/exasol/project-keeper-cli");
    }

    public static MavenRepository projectKeeperMavenPlugin() {
        return MavenRepository.of("com/exasol/project-keeper-maven-plugin");
    }

    public static MavenRepository of(String urlInfix) {
        return new MavenRepository(BASE_URL + urlInfix + METADATA_FILE);
    }

    static String getLatestVersion(Document document) throws XmlContentException {
        Node node = XPathErrorHandlingWrapper.runXPath(document, LATEST_VERSION_XPATH);
        if (node == null) {
            throw new XmlContentException("Couldn't find node /metadata/versioning/latest");
        }
        return node.getTextContent();
    }

    public MavenRepository(String url) {
        this.url = url;
    }

    public String getLatestVersion() throws ParserConfigurationException, SAXException, IOException, XmlContentException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        DocumentBuilder db = factory.newDocumentBuilder();
        try (InputStream stream = new URL(this.url).openStream();){
            String string = MavenRepository.getLatestVersion(db.parse(stream));
            return string;
        }
    }

    public String getUrl() {
        return this.url;
    }

    public static class XmlContentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public XmlContentException(String message) {
            super(message);
        }
    }
}

