/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.mavenrepo;

import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    public static final Pattern PATTERN = Pattern.compile("[0-9]+(\\.[0-9]+)*+");
    private static final int LESS = -1;
    private static final int EQUAL = 0;
    private static final int GREATER = 1;
    private final String raw;
    private final int[] items;

    public Version(String version) throws UnsupportedVersionFormatException {
        this.raw = version;
        this.items = Version.parseVersion(version);
    }

    private static int[] parseVersion(String v) throws UnsupportedVersionFormatException {
        if (!PATTERN.matcher(v).matches()) {
            throw new UnsupportedVersionFormatException(v);
        }
        return Arrays.stream(v.split("\\.")).mapToInt(Integer::parseInt).toArray();
    }

    @Override
    public int compareTo(Version other) {
        for (int i = 0; i < this.items.length; ++i) {
            int result = this.compare(i, other);
            if (!this.differs(result)) continue;
            return result;
        }
        if (this.items.length < other.items.length) {
            return -1;
        }
        return 0;
    }

    public boolean isGreaterOrEqualThan(Version other) {
        return this.compareTo(other) > -1;
    }

    private int compare(int i, Version other) {
        if (i >= other.items.length) {
            return 1;
        }
        return Integer.compare(this.items[i], other.items[i]);
    }

    private boolean differs(int result) {
        return result != 0;
    }

    public String toString() {
        return this.raw;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.items);
        result = 31 * result + Objects.hash(this.raw);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return Objects.equals(this.raw, other.raw) && Arrays.equals(this.items, other.items);
    }

    public static class UnsupportedVersionFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnsupportedVersionFormatException(String message) {
            super(message);
        }
    }
}

