/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources;

import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependencies;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChangeReport;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;

public final class AnalyzedMavenSource
implements AnalyzedSource {
    private final Path path;
    private final Set<ProjectKeeperModule> modules;
    private final boolean advertise;
    private final String artifactId;
    private final String projectName;
    private final String version;
    private final String javaVersion;
    private final DependencyChangeReport dependencyChanges;
    private final ProjectDependencies dependencies;
    private final boolean isRootProject;

    private AnalyzedMavenSource(AnalyzedMavenSourceBuilder builder) {
        this.path = builder.path;
        this.modules = builder.modules;
        this.advertise = builder.advertise;
        this.artifactId = builder.artifactId;
        this.projectName = builder.projectName;
        this.version = builder.version;
        this.javaVersion = builder.javaVersion;
        this.dependencyChanges = builder.dependencyChanges;
        this.dependencies = builder.dependencies;
        this.isRootProject = builder.isRootProject;
    }

    public static AnalyzedMavenSourceBuilder builder() {
        return new AnalyzedMavenSourceBuilder();
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public Set<ProjectKeeperModule> getModules() {
        return this.modules;
    }

    @Override
    public boolean isAdvertised() {
        return this.advertise;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public DependencyChangeReport getDependencyChanges() {
        return this.dependencyChanges;
    }

    @Override
    public ProjectDependencies getDependencies() {
        return this.dependencies;
    }

    public boolean isRootProject() {
        return this.isRootProject;
    }

    public String toString() {
        return "AnalyzedMavenSource [path=" + this.path + ", modules=" + this.modules + ", advertise=" + this.advertise + ", artifactId=" + this.artifactId + ", projectName=" + this.projectName + ", version=" + this.version + ", javaVersion=" + this.javaVersion + ", dependencyChanges=" + this.dependencyChanges + ", dependencies=" + this.dependencies + ", isRootProject=" + this.isRootProject + "]";
    }

    public int hashCode() {
        return Objects.hash(this.path, this.modules, this.advertise, this.artifactId, this.projectName, this.version, this.javaVersion, this.dependencyChanges, this.dependencies, this.isRootProject);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalyzedMavenSource other = (AnalyzedMavenSource)obj;
        return Objects.equals(this.path, other.path) && Objects.equals(this.modules, other.modules) && this.advertise == other.advertise && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.projectName, other.projectName) && Objects.equals(this.version, other.version) && Objects.equals(this.javaVersion, other.javaVersion) && Objects.equals(this.dependencyChanges, other.dependencyChanges) && Objects.equals(this.dependencies, other.dependencies) && this.isRootProject == other.isRootProject;
    }

    public static class AnalyzedMavenSourceBuilder {
        private Path path;
        private Set<ProjectKeeperModule> modules;
        private boolean advertise;
        private String artifactId;
        private String projectName;
        private String version;
        private String javaVersion = "11";
        private DependencyChangeReport dependencyChanges;
        private ProjectDependencies dependencies;
        private boolean isRootProject;

        private AnalyzedMavenSourceBuilder() {
        }

        public AnalyzedMavenSourceBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public AnalyzedMavenSourceBuilder modules(Set<ProjectKeeperModule> modules) {
            this.modules = modules;
            return this;
        }

        public AnalyzedMavenSourceBuilder advertise(boolean advertise) {
            this.advertise = advertise;
            return this;
        }

        public AnalyzedMavenSourceBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public AnalyzedMavenSourceBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public AnalyzedMavenSourceBuilder version(String version) {
            this.version = version;
            return this;
        }

        public AnalyzedMavenSourceBuilder javaVersion(String javaVersion) {
            if (javaVersion != null) {
                this.javaVersion = javaVersion;
            }
            return this;
        }

        public AnalyzedMavenSourceBuilder dependencyChanges(DependencyChangeReport dependencyChanges) {
            this.dependencyChanges = dependencyChanges;
            return this;
        }

        public AnalyzedMavenSourceBuilder dependencies(ProjectDependencies dependencies) {
            this.dependencies = dependencies;
            return this;
        }

        public AnalyzedMavenSourceBuilder isRootProject(boolean isRootProject) {
            this.isRootProject = isRootProject;
            return this;
        }

        public AnalyzedMavenSource build() {
            return new AnalyzedMavenSource(this);
        }

        public String toString() {
            return "AnalyzedMavenSourceBuilder [path=" + this.path + ", modules=" + this.modules + ", advertise=" + this.advertise + ", artifactId=" + this.artifactId + ", projectName=" + this.projectName + ", version=" + this.version + ", dependencyChanges=" + this.dependencyChanges + ", dependencies=" + this.dependencies + ", isRootProject=" + this.isRootProject + "]";
        }
    }
}

