/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.config.ProjectKeeperConfig;
import com.exasol.projectkeeper.shared.config.Source;
import com.exasol.projectkeeper.shared.config.SourceType;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.sources.analyze.LanguageSpecificSourceAnalyzer;
import com.exasol.projectkeeper.sources.analyze.MavenSourceAnalyzer;
import com.exasol.projectkeeper.sources.analyze.golang.GolangSourceAnalyzer;
import com.exasol.projectkeeper.sources.analyze.npm.NpmSourceAnalyzer;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SourceAnalyzer {
    private final Map<SourceType, LanguageSpecificSourceAnalyzer> sourceAnalyzers;

    SourceAnalyzer(Map<SourceType, LanguageSpecificSourceAnalyzer> sourceAnalyzers) {
        this.sourceAnalyzers = sourceAnalyzers;
    }

    public static SourceAnalyzer create(ProjectKeeperConfig config, Path mvnRepo, String ownVersion) {
        return new SourceAnalyzer(SourceAnalyzer.getLanguageSpecificSourceAnalyzers(config, mvnRepo, ownVersion));
    }

    private static Map<SourceType, LanguageSpecificSourceAnalyzer> getLanguageSpecificSourceAnalyzers(ProjectKeeperConfig config, Path mvnRepo, String ownVersion) {
        return Map.of(SourceType.MAVEN, new MavenSourceAnalyzer(mvnRepo, ownVersion), SourceType.GOLANG, new GolangSourceAnalyzer(config), SourceType.NPM, new NpmSourceAnalyzer());
    }

    public List<AnalyzedSource> analyze(Path projectDir, List<Source> sources) {
        this.validateUniqueSourcePaths(sources);
        Map<Path, AnalyzedSource> analyzedSources = this.analyzeSources(projectDir, sources);
        return this.fixOrder(sources, analyzedSources);
    }

    private Map<Path, AnalyzedSource> analyzeSources(Path projectDir, List<Source> sources) {
        Map<SourceType, List<Source>> groupedSources = sources.stream().collect(Collectors.groupingBy(Source::getType));
        HashMap<Path, AnalyzedSource> analyzedSources = new HashMap<Path, AnalyzedSource>(sources.size());
        for (Map.Entry<SourceType, List<Source>> entry : groupedSources.entrySet()) {
            LanguageSpecificSourceAnalyzer analyzer = this.getAnalyzer(entry.getKey());
            analyzer.analyze(projectDir, entry.getValue()).forEach(source -> analyzedSources.put(source.getPath(), (AnalyzedSource)source));
        }
        return analyzedSources;
    }

    private List<AnalyzedSource> fixOrder(List<Source> sources, Map<Path, AnalyzedSource> analyzedSources) {
        return sources.stream().map(source -> this.findSource((Source)source, analyzedSources)).collect(Collectors.toList());
    }

    private AnalyzedSource findSource(Source source, Map<Path, AnalyzedSource> analyzedSources) {
        AnalyzedSource analyzedSource = analyzedSources.get(source.getPath());
        if (analyzedSource != null) {
            return analyzedSource;
        }
        throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-150").message("Did not find analyzed source for path {{path}}, all analyzed sources: {{analyzed sources}}", new Object[]{source.getPath(), analyzedSources}).ticketMitigation().toString());
    }

    private void validateUniqueSourcePaths(List<Source> sources) {
        Map sourceFrequencies = sources.stream().map(Source::getPath).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        List duplicatePaths = sourceFrequencies.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!duplicatePaths.isEmpty()) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-149").message("Sources use duplicate paths {{duplicate paths|u}}.", new Object[]{duplicatePaths}).mitigation("Make sure that sources in .project-keeper.yml have unique paths.", new Object[0]).toString());
        }
    }

    private LanguageSpecificSourceAnalyzer getAnalyzer(SourceType type) {
        LanguageSpecificSourceAnalyzer analyzer = this.sourceAnalyzers.get(type);
        if (analyzer == null) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-131").message("No source analyzer found for source type {{source type}}.", new Object[]{type}).ticketMitigation().toString());
        }
        return analyzer;
    }
}

