/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.generic;

import com.exasol.projectkeeper.shared.dependencies.VersionedDependency;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import com.exasol.projectkeeper.shared.dependencychanges.NewDependency;
import com.exasol.projectkeeper.shared.dependencychanges.RemovedDependency;
import com.exasol.projectkeeper.shared.dependencychanges.UpdatedDependency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DependencyChanges {
    private Map<String, VersionedDependency> from;
    private Map<String, VersionedDependency> to;
    private final List<DependencyChange> changes = new ArrayList<DependencyChange>();

    public static DependencyChanges builder() {
        return new DependencyChanges();
    }

    public DependencyChanges from(Optional<List<VersionedDependency>> dependencies) {
        this.from = DependencyChanges.toMap(dependencies.orElse(Collections.emptyList()));
        return this;
    }

    public DependencyChanges to(List<VersionedDependency> dependencies) {
        this.to = DependencyChanges.toMap(dependencies);
        return this;
    }

    private static Map<String, VersionedDependency> toMap(List<VersionedDependency> dependencies) {
        return dependencies.stream().collect(Collectors.toMap(VersionedDependency::getName, Function.identity()));
    }

    public List<DependencyChange> build() {
        String depName;
        for (Map.Entry<String, VersionedDependency> entry : this.to.entrySet()) {
            depName = entry.getKey();
            String newVersion = entry.getValue().getVersion();
            if (this.from.containsKey(depName)) {
                String oldVersion = this.from.get(depName).getVersion();
                if (oldVersion.equals(newVersion)) continue;
                this.updatedDependency(depName, oldVersion, newVersion);
                continue;
            }
            this.addedDependency(depName, newVersion);
        }
        for (Map.Entry<String, VersionedDependency> entry : this.from.entrySet()) {
            depName = entry.getKey();
            if (this.to.containsKey(depName)) continue;
            this.removedDependency(depName, entry.getValue().getVersion());
        }
        return this.changes;
    }

    private void addedDependency(String module, String version) {
        this.changes.add((DependencyChange)new NewDependency(null, module, version));
    }

    private void removedDependency(String module, String version) {
        this.changes.add((DependencyChange)new RemovedDependency(null, module, version));
    }

    private void updatedDependency(String module, String oldVersion, String newVersion) {
        this.changes.add((DependencyChange)new UpdatedDependency(null, module, oldVersion, newVersion));
    }

    public DependencyChanges withChange(String module, Optional<String> previous, Optional<String> current) {
        if (previous.isEmpty() && current.isPresent()) {
            this.addedDependency(module, current.get());
        } else if (previous.isPresent() && current.isEmpty()) {
            this.removedDependency(module, previous.get());
        } else if (previous.isPresent() && !previous.equals(current)) {
            this.updatedDependency(module, previous.get(), current.get());
        }
        return this;
    }
}

