/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.generic;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class ShellCommand {
    static final Logger LOGGER = Logger.getLogger(ShellCommand.class.getName());
    private Duration timeout;
    private String mainCommand;
    private String subCommand;
    private final List<String> options = new ArrayList<String>();

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this.mainCommand + (String)(this.subCommand == null ? "" : " " + this.subCommand);
    }

    public List<String> commandline() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.mainCommand);
        if (this.subCommand != null) {
            result.add(this.subCommand);
        }
        result.addAll(this.options);
        return result;
    }

    public Duration timeout() {
        return this.timeout;
    }

    public static class Builder {
        private final ShellCommand shellCommand = new ShellCommand();

        public Builder timeout(Duration timeout) {
            this.shellCommand.timeout = timeout;
            return this;
        }

        public Builder command(String command) {
            return this.command(command, null);
        }

        public Builder command(String main, String sub) {
            this.shellCommand.mainCommand = main;
            this.shellCommand.subCommand = sub;
            return this;
        }

        public Builder args(String ... value) {
            this.shellCommand.options.addAll(Arrays.asList(value));
            return this;
        }

        public ShellCommand build() {
            return this.shellCommand;
        }
    }
}

