/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.golang;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.dependencies.VersionedDependency;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GoModFileParser {
    private static final Consumer<RegexMatch> IGNORE = match -> {};
    private final List<RegexAction> regexps;
    String moduleName = null;
    String goVersion;
    boolean insideRequireBlock = false;
    boolean insideReplaceBlock = false;
    final List<VersionedDependency> dependencies = new ArrayList<VersionedDependency>();

    GoModFileParser() {
        this.regexps = List.of(RegexAction.create("^//(.+)$", IGNORE), RegexAction.create("^replace \\($", match -> {
            this.insideReplaceBlock = true;
        }), RegexAction.create("^replace\\s+(.+)$", IGNORE), RegexAction.create("^module\\s+(.+)$", match -> {
            this.moduleName = match.group(1);
        }), RegexAction.create("^go\\s+(.+)$", match -> {
            this.goVersion = match.group(1);
        }), RegexAction.create("^require \\($", match -> {
            this.insideRequireBlock = true;
        }), RegexAction.create("^\\)$", match -> {
            this.insideRequireBlock = false;
            this.insideReplaceBlock = false;
        }), RegexAction.create("^(?:require\\s+)?([^\\s]+)\\s+([^\\s/]+)(?:\\s*//\\s*(.*))?$", match -> {
            if (!this.insideReplaceBlock) {
                this.dependencies.add(this.createDependency(match.getGroups()));
            }
        }), RegexAction.create(".*", match -> {
            if (!this.insideReplaceBlock) {
                throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-138").message("Found unexpected line {{line}} in go.mod file", new Object[]{match.getLine()}).toString());
            }
        }));
    }

    private VersionedDependency createDependency(List<String> groups) {
        boolean indirect = groups.size() >= 3 && groups.get(2) != null && groups.get(2).startsWith("indirect");
        return VersionedDependency.builder().name(groups.get(0)).version(groups.get(1)).isIndirect(indirect).build();
    }

    void parse(String content) {
        Arrays.stream(content.split("\n")).map(String::trim).forEach(this::readLine);
    }

    void readLine(String line) {
        if (line.isBlank()) {
            return;
        }
        for (RegexAction regex : this.regexps) {
            Optional<RegexMatch> match = regex.matches(line);
            if (!match.isPresent()) continue;
            match.get().runAction();
            break;
        }
    }

    private static class RegexMatch {
        private final Matcher matcher;
        private final Consumer<RegexMatch> action;
        private final String line;

        RegexMatch(Matcher matcher, String line, Consumer<RegexMatch> action) {
            this.matcher = matcher;
            this.line = line;
            this.action = action;
        }

        void runAction() {
            this.action.accept(this);
        }

        String group(int group) {
            return this.matcher.group(group);
        }

        String getLine() {
            return this.line;
        }

        List<String> getGroups() {
            ArrayList<String> groups = new ArrayList<String>(this.matcher.groupCount());
            for (int i = 1; i <= this.matcher.groupCount(); ++i) {
                groups.add(this.matcher.group(i));
            }
            return groups;
        }
    }

    private static class RegexAction {
        private final Pattern pattern;
        private final Consumer<RegexMatch> action;

        private RegexAction(Pattern pattern, Consumer<RegexMatch> action) {
            this.pattern = pattern;
            this.action = action;
        }

        static RegexAction create(String pattern, Consumer<RegexMatch> action) {
            return new RegexAction(Pattern.compile(pattern), action);
        }

        Optional<RegexMatch> matches(String string) {
            Matcher matcher = this.pattern.matcher(string);
            if (matcher.matches()) {
                return Optional.of(new RegexMatch(matcher, string, this.action));
            }
            return Optional.empty();
        }
    }
}

