/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.golang;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.dependencies.BaseDependency;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependencies;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependency;
import com.exasol.projectkeeper.shared.dependencies.VersionedDependency;
import com.exasol.projectkeeper.sources.analyze.golang.GoModule;
import com.exasol.projectkeeper.sources.analyze.golang.GolangDependencyLicense;
import com.exasol.projectkeeper.sources.analyze.golang.GolangServices;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class GolangDependencyCalculator {
    private final GoModule moduleInfo;
    private final Path projectPath;
    private final GolangServices golangServices;
    private Map<String, GolangDependencyLicense> compileDependencyLicenses;
    private Map<String, GolangDependencyLicense> allLicenses;

    private GolangDependencyCalculator(GolangServices golangServices, Path projectPath, GoModule moduleInfo) {
        this.golangServices = golangServices;
        this.projectPath = projectPath;
        this.moduleInfo = moduleInfo;
    }

    static ProjectDependencies calculateDependencies(GolangServices golangServices, Path projectPath, GoModule moduleInfo) {
        golangServices.installDependencies(projectPath);
        GolangDependencyCalculator calculator = new GolangDependencyCalculator(golangServices, projectPath, moduleInfo);
        return calculator.getDependencies();
    }

    private ProjectDependencies getDependencies() {
        this.compileDependencyLicenses = this.fetchLicensesForMainModule();
        this.allLicenses = new HashMap<String, GolangDependencyLicense>(this.compileDependencyLicenses);
        List projectDependencies = this.moduleInfo.getDependencies().stream().map(this::convertDependency).collect(Collectors.toList());
        return new ProjectDependencies(projectDependencies);
    }

    private ProjectDependency convertDependency(VersionedDependency dependency) {
        return ProjectDependency.builder().name(dependency.getName()).type(this.getDependencyType(dependency.getName())).websiteUrl(null).licenses(List.of(this.getLicense(dependency.getName()).toLicense())).build();
    }

    private GolangDependencyLicense getLicense(String moduleName) {
        if (this.allLicenses.containsKey(moduleName)) {
            return this.allLicenses.get(moduleName);
        }
        Optional<GolangDependencyLicense> prefixMatch = this.allLicenses.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(moduleName)).map(Map.Entry::getValue).findAny();
        if (prefixMatch.isPresent()) {
            return prefixMatch.get();
        }
        return this.fetchLicense(moduleName);
    }

    private GolangDependencyLicense fetchLicense(String moduleName) {
        Map<String, GolangDependencyLicense> licenses = this.fetchAllLicenses(moduleName);
        this.allLicenses.putAll(licenses);
        GolangDependencyLicense license = licenses.get(moduleName);
        if (license == null) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-147").message("No license found for test dependency module {{module name}}, all licenses: {{all licenses}}", new Object[]{moduleName, licenses}).toString());
        }
        return license;
    }

    private Map<String, GolangDependencyLicense> fetchLicensesForMainModule() {
        return this.golangServices.getLicenses(this.projectPath, "./...");
    }

    private Map<String, GolangDependencyLicense> fetchAllLicenses(String moduleName) {
        Path moduleDir = this.golangServices.getModuleDir(this.projectPath, moduleName);
        return this.golangServices.getLicenses(moduleDir, moduleName);
    }

    private BaseDependency.Type getDependencyType(String moduleName) {
        return this.compileDependencyLicenses.containsKey(moduleName) ? BaseDependency.Type.COMPILE : BaseDependency.Type.TEST;
    }
}

