/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.golang;

import com.exasol.projectkeeper.shared.dependencies.BaseDependency;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependency;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class GolangDependencyType {
    static final Logger LOGGER = Logger.getLogger(GolangDependencyType.class.getName());
    private final List<ProjectDependency> dependencies;
    private final Map<String, BaseDependency.Type> types;

    GolangDependencyType(List<ProjectDependency> dependencies) {
        this.dependencies = dependencies;
        this.types = dependencies.stream().collect(Collectors.toMap(ProjectDependency::getName, ProjectDependency::getType));
    }

    BaseDependency.Type getType(DependencyChange change) {
        String moduleName = change.getArtifactId();
        if (this.isGolangRuntime(moduleName)) {
            return BaseDependency.Type.COMPILE;
        }
        BaseDependency.Type type = this.types.get(moduleName);
        if (type != null) {
            return type;
        }
        return this.getTypeByPrefix(moduleName);
    }

    private boolean isGolangRuntime(String name) {
        return name.equals("golang");
    }

    private BaseDependency.Type getTypeByPrefix(String moduleName) {
        DependencyMatcher dependencyMatcher = DependencyMatcher.forModule(moduleName);
        return this.dependencies.stream().filter(dependencyMatcher::matches).map(ProjectDependency::getType).findFirst().orElse(BaseDependency.Type.UNKNOWN);
    }

    static interface DependencyMatcher {
        public static final Pattern PATTERN = Pattern.compile(".*/v\\d+");
        public static final DependencyMatcher NEVER = dep -> false;

        public static DependencyMatcher forModule(String moduleName) {
            if (!PATTERN.matcher(moduleName).matches()) {
                return NEVER;
            }
            String prefix = moduleName.substring(0, moduleName.lastIndexOf("/"));
            LOGGER.finest(() -> "Found prefix '" + prefix + "' for module '" + moduleName + "'.");
            return new PrefixMatcher(prefix);
        }

        public boolean matches(ProjectDependency var1);

        public static class PrefixMatcher
        implements DependencyMatcher {
            private final String prefix;

            PrefixMatcher(String prefix) {
                this.prefix = prefix;
            }

            @Override
            public boolean matches(ProjectDependency dependency) {
                return dependency.getName().startsWith(this.prefix);
            }
        }
    }
}

