/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.golang;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.config.FixedVersion;
import com.exasol.projectkeeper.shared.config.ProjectKeeperConfig;
import com.exasol.projectkeeper.shared.config.VersionConfig;
import com.exasol.projectkeeper.shared.dependencies.VersionedDependency;
import com.exasol.projectkeeper.shared.dependencychanges.DependencyChange;
import com.exasol.projectkeeper.sources.analyze.generic.CommandExecutor;
import com.exasol.projectkeeper.sources.analyze.generic.DependencyChanges;
import com.exasol.projectkeeper.sources.analyze.generic.GitService;
import com.exasol.projectkeeper.sources.analyze.generic.PreviousRelease;
import com.exasol.projectkeeper.sources.analyze.generic.ShellCommand;
import com.exasol.projectkeeper.sources.analyze.golang.GoBinary;
import com.exasol.projectkeeper.sources.analyze.golang.GoModFile;
import com.exasol.projectkeeper.sources.analyze.golang.GoModule;
import com.exasol.projectkeeper.sources.analyze.golang.GolangDependencyLicense;
import com.exasol.projectkeeper.sources.analyze.golang.SimpleProcess;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class GolangServices {
    public static final String GOLANG_DEPENDENCY_NAME = "golang";
    private static final Logger LOGGER = Logger.getLogger(GolangServices.class.getName());
    private static final List<String> COMMAND_LIST_DIRECT_DEPENDENCIES = List.of("go", "list", "-f", "{{if not .Indirect}}{{.}}{{end}}", "-m", "all");
    private static final Duration EXECUTION_TIMEOUT = Duration.ofSeconds(30L);
    private final CommandExecutor executor;
    private final GitService git;
    private final Supplier<String> projectVersionSupplier;

    GolangServices(ProjectKeeperConfig config) {
        this(new CommandExecutor(), new GitService(), () -> GolangServices.extractVersion(config));
    }

    GolangServices(CommandExecutor executor, GitService git, Supplier<String> projectVersionSupplier) {
        this.executor = executor;
        this.git = git;
        this.projectVersionSupplier = projectVersionSupplier;
    }

    private static String extractVersion(ProjectKeeperConfig config) {
        VersionConfig versionConfig = config.getVersionConfig();
        if (versionConfig == null) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-146").message("Version config is missing.", new Object[0]).mitigation("Add a fixed version to your .project-keeper.yml, e.g. version: 1.2.3.", new Object[0]).toString());
        }
        if (versionConfig instanceof FixedVersion) {
            return ((FixedVersion)versionConfig).getVersion();
        }
        throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-136").message("Version config has unexpected type {{type}}, expected a fixed version.", new Object[]{versionConfig.getClass().getName()}).mitigation("Add a fixed version to your .project-keeper.yml, e.g. version: 1.2.3.", new Object[0]).toString());
    }

    Map<String, GolangDependencyLicense> getLicenses(Path absoluteSourcePath, String module) {
        String[] licenses = this.retrieveLicenses(absoluteSourcePath, module).split("\n");
        return Arrays.stream(licenses).filter(Predicate.not(String::isBlank)).map(this::convertDependencyLicense).collect(Collectors.toMap(GolangDependencyLicense::getModuleName, Function.identity()));
    }

    private String retrieveLicenses(Path absoluteSourcePath, String module) {
        GoBinary goLicenses = GoBinary.GO_LICENSES.install();
        ShellCommand shellCommand = ShellCommand.builder().timeout(EXECUTION_TIMEOUT).command(goLicenses.command()).args("csv", module).build();
        try {
            return this.executor.execute(shellCommand, absoluteSourcePath);
        }
        catch (RuntimeException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-142").message("Error starting the 'go-licenses' binary in working dir {{working dir}}.", new Object[0]).parameter("working dir", (Object)absoluteSourcePath, "working directory where go-licenses was executed").mitigation("Verify that 'go-licenses' is installed.", new Object[0]).mitigation("Install it by running 'go install github.com/google/go-licenses@latest'.", new Object[0]).mitigation("If it is already installed, re-install it by running the same command.", new Object[0]).mitigation("This might be necessary after installing a new Go version.", new Object[0]).toString(), exception);
        }
    }

    Path getModuleDir(Path absoluteSourcePath, String moduleName) {
        ShellCommand shellCommand = ShellCommand.builder().timeout(Duration.ofSeconds(3L)).command(GoBinary.GO.command()).args("list", "-m", "-f", "{{.Dir}}", moduleName).build();
        String output = this.executor.execute(shellCommand, absoluteSourcePath).trim();
        if (output.isEmpty()) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-160").message("Did not get directory for module {{module name}}.", new Object[]{moduleName}).ticketMitigation().toString());
        }
        Path path = Path.of(output, new String[0]).toAbsolutePath();
        LOGGER.finest(() -> "Found module dir '" + path + "' for module '" + moduleName + "'");
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-156").message("Directory {{directory}} for module {{module name}} does not exist", new Object[]{path, moduleName}).ticketMitigation().toString());
        }
        return path;
    }

    private GolangDependencyLicense convertDependencyLicense(String line) {
        String[] parts = line.split(",");
        if (parts.length != 3) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-132").message("Invalid output line of command go-licenses: {{invalid line}}, expected 3 fields but got {{actual field count}}", new Object[]{line, parts.length}).toString());
        }
        String moduleName = parts[0];
        String licenseUrl = parts[1];
        String licenseName = parts[2];
        return new GolangDependencyLicense(moduleName, licenseName, licenseUrl);
    }

    GoModule getModuleInfo(Path absoluteSourcePath) {
        SimpleProcess process = SimpleProcess.start(absoluteSourcePath, COMMAND_LIST_DIRECT_DEPENDENCIES);
        try {
            process.waitUntilFinished(EXECUTION_TIMEOUT);
        }
        catch (IllegalStateException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-157").message("Failed to list direct dependencies.", new Object[0]).mitigation("Run 'go mod tidy' and try again.", new Object[0]).toString(), exception);
        }
        String[] output = process.getOutputStreamContent().split("\n");
        List<VersionedDependency> dependencies = Arrays.stream(output).skip(1L).map(this::convertDependency).collect(Collectors.toList());
        return new GoModule(output[0], dependencies);
    }

    private VersionedDependency convertDependency(String line) {
        String[] parts = line.split(" ");
        if (parts.length != 2) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-139").message("Invalid output line of command {{command}}: {{invalid line}}", new Object[]{String.join((CharSequence)" ", COMMAND_LIST_DIRECT_DEPENDENCIES), line}).toString());
        }
        String moduleName = parts[0];
        String version = parts[1];
        return VersionedDependency.builder().name(moduleName).version(version).isIndirect(false).build();
    }

    List<DependencyChange> getDependencyChanges(Path projectDir, Path relativeModFile) {
        Optional<GoModFile> previous = new PreviousRelease(this.git).projectDir(projectDir).currentVersion(this.getProjectVersion()).file(relativeModFile).getContent().map(GoModFile::parse);
        GoModFile current = GoModFile.parse(this.readFile(projectDir.resolve(relativeModFile)));
        return this.calculateChanges(previous, current);
    }

    private String readFile(Path file) {
        try {
            return Files.readString(file, StandardCharsets.UTF_8);
        }
        catch (IOException exception) {
            throw new UncheckedIOException(ExaError.messageBuilder((String)"E-PK-CORE-135").message("Error loading file {{file}}", new Object[]{file}).toString(), exception);
        }
    }

    List<DependencyChange> calculateChanges(Optional<GoModFile> previous, GoModFile current) {
        return DependencyChanges.builder().from(previous.map(GoModFile::getDirectDependencies)).to(current.getDirectDependencies()).withChange(GOLANG_DEPENDENCY_NAME, previous.map(GoModFile::getGoVersion), Optional.ofNullable(current.getGoVersion())).build();
    }

    String getProjectVersion() {
        return this.projectVersionSupplier.get();
    }

    void installDependencies(Path projectPath) {
        ShellCommand sc = ShellCommand.builder().timeout(Duration.ofMinutes(2L)).command(GoBinary.GO.command()).args("get", "-t", "./...").build();
        this.executor.execute(sc, projectPath);
    }
}

