/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.npm;

import com.exasol.projectkeeper.shared.dependencies.License;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependency;
import com.exasol.projectkeeper.shared.dependencies.VersionedDependency;
import com.exasol.projectkeeper.sources.analyze.npm.NpmLicense;
import com.exasol.projectkeeper.sources.analyze.npm.NpmServices;
import com.exasol.projectkeeper.sources.analyze.npm.PackageJson;
import jakarta.json.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class NpmDependencies {
    private final NpmServices services;
    private final PackageJson packageJson;
    private JsonObject additionalInfo;
    private Map<String, List<NpmLicense>> licenseMap;

    NpmDependencies(NpmServices services, PackageJson packageJson) {
        this.services = services;
        this.packageJson = packageJson;
    }

    List<ProjectDependency> getDependencies() {
        this.additionalInfo = this.services.listDependencies(this.packageJson.getWorkingDir()).getJsonObject("dependencies");
        this.licenseMap = this.retrieveNpmLicenses();
        return this.packageJson.getDependencies().stream().map(this::projectDependency).collect(Collectors.toList());
    }

    private Map<String, List<NpmLicense>> retrieveNpmLicenses() {
        JsonObject json = this.services.getLicenses(this.packageJson.getWorkingDir());
        return json.keySet().stream().map(key -> NpmLicense.from(key, json)).collect(Collectors.toMap(NpmLicense::getModule, List::of));
    }

    private ProjectDependency projectDependency(VersionedDependency versionedDependency) {
        String moduleName = versionedDependency.getName();
        return ProjectDependency.builder().name(moduleName).websiteUrl(this.getUrl(moduleName)).type(versionedDependency.getType()).licenses(this.moduleLicenses(moduleName)).build();
    }

    private List<License> moduleLicenses(String moduleName) {
        return Optional.ofNullable(this.licenseMap.get(moduleName)).orElse(Collections.emptyList()).stream().map(NpmLicense::toLicense).collect(Collectors.toList());
    }

    private String getUrl(String moduleName) {
        return this.additionalInfo.getJsonObject(moduleName).getString("resolved");
    }
}

