/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.npm;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.OsCheck;
import com.exasol.projectkeeper.shared.dependencies.ProjectDependencies;
import com.exasol.projectkeeper.sources.analyze.generic.CommandExecutor;
import com.exasol.projectkeeper.sources.analyze.generic.GitService;
import com.exasol.projectkeeper.sources.analyze.generic.PreviousRelease;
import com.exasol.projectkeeper.sources.analyze.generic.ShellCommand;
import com.exasol.projectkeeper.sources.analyze.npm.JsonIo;
import com.exasol.projectkeeper.sources.analyze.npm.NpmDependencies;
import com.exasol.projectkeeper.sources.analyze.npm.PackageJson;
import com.exasol.projectkeeper.sources.analyze.npm.PackageJsonReader;
import jakarta.json.JsonObject;
import java.io.StringReader;
import java.nio.file.Path;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

class NpmServices {
    private static final String NPM = "npm" + OsCheck.suffix(".cmd");
    private static final String NPX = "npx" + OsCheck.suffix(".cmd");
    static final ShellCommand FETCH_DEPENDENCIES = ShellCommand.builder().command(NPM, "ci").timeout(Duration.ofMinutes(5L)).build();
    static final ShellCommand LIST_DEPENDENCIES = ShellCommand.builder().command(NPM, "list").timeout(Duration.ofMinutes(2L)).args("--location=project", "--depth=0", "--json").build();
    static final ShellCommand LICENSE_CHECKER = ShellCommand.builder().command(NPX, "license-checker").timeout(Duration.ofMinutes(2L)).args("--location=project", "--direct", "--json").build();
    private final CommandExecutor executor;
    private final GitService git;
    private final Set<Path> workingDirsWithFetchedDependencies = new HashSet<Path>();

    NpmServices(CommandExecutor executor, GitService git) {
        this.executor = executor;
        this.git = git;
    }

    PackageJson readPackageJson(Path path) {
        return PackageJsonReader.read(path);
    }

    ProjectDependencies getDependencies(PackageJson packageJson) {
        return new ProjectDependencies(new NpmDependencies(this, packageJson).getDependencies());
    }

    Optional<PackageJson> retrievePrevious(Path projectDir, PackageJson current) {
        return new PreviousRelease(this.git).projectDir(projectDir).currentVersion(current.getVersion()).file(projectDir.relativize(current.getPath())).getContent().map(string -> PackageJsonReader.read(current.getPath(), string));
    }

    JsonObject listDependencies(Path folder) {
        return this.getJsonOutput(LIST_DEPENDENCIES, folder);
    }

    JsonObject getLicenses(Path folder) {
        return this.getJsonOutput(LICENSE_CHECKER, folder);
    }

    private JsonObject getJsonOutput(ShellCommand cmd, Path workingDir) {
        this.fetchDependencies(workingDir);
        String stdout = this.executor.execute(cmd, workingDir);
        return JsonIo.read(new StringReader(stdout));
    }

    void fetchDependencies(Path workingDir) {
        if (this.workingDirsWithFetchedDependencies.contains(workingDir)) {
            return;
        }
        try {
            this.executor.execute(FETCH_DEPENDENCIES, workingDir);
        }
        catch (RuntimeException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-168").message("Installing dependencies in {{working dir}} via 'npm ci' failed.", new Object[0]).mitigation("Try running 'npm ci' manually in directory {{working dir}}.", new Object[0]).parameter("working dir", (Object)workingDir, "the working directory where 'npm ci' was executed").toString(), exception);
        }
        this.workingDirsWithFetchedDependencies.add(workingDir);
    }
}

