/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.sources.analyze.npm;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.dependencies.BaseDependency;
import com.exasol.projectkeeper.shared.dependencies.VersionedDependency;
import com.exasol.projectkeeper.sources.analyze.npm.JsonIo;
import com.exasol.projectkeeper.sources.analyze.npm.PackageJson;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

final class PackageJsonReader {
    private static final String MODULE_PREFIX = "@exasol/";

    PackageJsonReader() {
    }

    static PackageJson read(Path path) {
        return new PackageJsonReader().read(path, JsonIo.uncheckedRead(path));
    }

    static PackageJson read(Path path, String string) {
        JsonObject json = JsonIo.read(new StringReader(string));
        return new PackageJsonReader().read(path, json);
    }

    PackageJson read(Path path, JsonObject content) {
        String module = this.retrieveModuleName(content);
        String version = this.retrieveModuleVersion(content);
        ArrayList<VersionedDependency> dependencies = new ArrayList<VersionedDependency>();
        dependencies.addAll(this.versionedDependencies(content, DependencyKey.DEV));
        dependencies.addAll(this.versionedDependencies(content, DependencyKey.COMPILE));
        return new PackageJson(path, module, version, dependencies);
    }

    private String retrieveModuleName(JsonObject packageJson) {
        JsonString raw = packageJson.getJsonString("name");
        if (raw == null) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-CORE-163").message("Missing attribute 'name' in package.json.", new Object[0]).mitigation("Add a 'name' attribute.", new Object[0]).toString());
        }
        String rawString = raw.getString();
        if (!rawString.startsWith(MODULE_PREFIX)) {
            return rawString;
        }
        return rawString.substring(MODULE_PREFIX.length());
    }

    private String retrieveModuleVersion(JsonObject content) {
        JsonString version = content.getJsonString("version");
        if (version == null) {
            throw new IllegalArgumentException(ExaError.messageBuilder((String)"E-PK-CORE-164").message("Missing attribute 'version' in package.json.", new Object[0]).mitigation("Add a 'version' attribute.", new Object[0]).toString());
        }
        return version.getString();
    }

    private List<VersionedDependency> versionedDependencies(JsonObject packageJson, DependencyKey key) {
        JsonObject dependencies = this.orEmpty(packageJson.getJsonObject(key.key));
        return dependencies.keySet().stream().map(k -> this.dependency((String)k, key.type, dependencies.getString(k))).collect(Collectors.toList());
    }

    private JsonObject orEmpty(JsonObject jsonObject) {
        return jsonObject != null ? jsonObject : JsonValue.EMPTY_JSON_OBJECT;
    }

    private VersionedDependency dependency(String name, BaseDependency.Type type, String version) {
        return VersionedDependency.builder().type(type).name(name).version(version).isIndirect(false).build();
    }

    static enum DependencyKey {
        COMPILE("dependencies", BaseDependency.Type.COMPILE),
        DEV("devDependencies", BaseDependency.Type.DEV);

        private final String key;
        private final BaseDependency.Type type;

        private DependencyKey(String key, BaseDependency.Type type) {
            this.key = key;
            this.type = type;
        }
    }
}

