/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.stream;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.stream.CollectingConsumer;
import com.exasol.projectkeeper.stream.StreamConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AsyncStreamReader {
    private static final Logger LOGGER = Logger.getLogger(AsyncStreamReader.class.getName());
    private Executor executor;

    public AsyncStreamReader() {
        this(AsyncStreamReader.createThreadExecutor());
    }

    AsyncStreamReader(Executor executor) {
        this.executor = executor;
    }

    private static Executor createThreadExecutor() {
        return runnable -> {
            Thread thread = new Thread(runnable);
            thread.setUncaughtExceptionHandler(new LoggingExceptionHandler());
            thread.start();
        };
    }

    public CollectingConsumer startCollectingConsumer(InputStream stream) {
        CollectingConsumer consumer = new CollectingConsumer();
        this.executor.execute(() -> this.readStream(stream, consumer));
        return consumer;
    }

    private void readStream(InputStream stream, StreamConsumer consumer) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                consumer.accept(line);
            }
            consumer.readFinished();
        }
        catch (IOException exception) {
            consumer.readFailed(exception);
            LOGGER.log(Level.WARNING, ExaError.messageBuilder((String)"E-PK-CORE-98").message("Failed to read input stream", new Object[0]).toString(), exception);
        }
    }

    private static class LoggingExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private LoggingExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            LOGGER.log(Level.SEVERE, ExaError.messageBuilder((String)"E-PK-CORE-97").message("Failed to read input stream", new Object[0]).ticketMitigation().toString(), throwable);
        }
    }
}

