/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.AbstractFileValidator;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public abstract class AbstractFileContentValidator
extends AbstractFileValidator {
    protected AbstractFileContentValidator(Path projectDirectory, Path filePath) {
        super(projectDirectory, filePath);
    }

    @Override
    protected final List<ValidationFinding> validateContent(Path file) {
        try {
            String content = Files.readString(file);
            return this.validateContent(content);
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-60").message("Failed to read file {{file name}} for validation.", new Object[]{file}).toString());
        }
    }

    protected abstract List<ValidationFinding> validateContent(String var1);

    @Override
    protected final void writeTemplateFile(Path target) throws IOException {
        Files.writeString(target, (CharSequence)this.getTemplate(), new OpenOption[0]);
    }

    protected abstract String getTemplate();
}

