/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DeletedFilesValidator
implements Validator {
    private static final String GITHUB_WORKFLOWS = ".github/workflows";
    private static final Map<Path, String> FILES_THAT_MUST_NOT_EXIST = Map.of(Path.of(".github/workflows", "maven.yml"), "We renamed maven.yml to dependencies_check.yml", Path.of("assembly", "all-dependencies.xml"), "We moved assembly/all-dependencies.xml to src/assembly/all-dependencies.xml", Path.of(".github/workflows", "maven_central_release.yml"), "We renamed maven.yml to release_droid_release_on_maven_central.yml", Path.of(".github/workflows", "github_release.yml"), "We renamed maven.yml to release_droid_upload_github_release_assets.yml");
    private final Path projectDirectory;

    public DeletedFilesValidator(Path projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    @Override
    public List<ValidationFinding> validate() {
        return FILES_THAT_MUST_NOT_EXIST.entrySet().stream().map(entry -> {
            Path fileThatMustNotExist = (Path)entry.getKey();
            String reason = (String)entry.getValue();
            Path pathThatMustExist = this.projectDirectory.resolve(fileThatMustNotExist);
            File file = pathThatMustExist.toFile();
            if (file.exists()) {
                return SimpleValidationFinding.withMessage(this.getFileExistsErrorMessage(fileThatMustNotExist, reason)).andFix(this.getFix(fileThatMustNotExist.toString(), file)).build();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String getFileExistsErrorMessage(Path fileThatMustNotExist, String reason) {
        return ExaError.messageBuilder((String)"E-PK-CORE-26").message("{{FILE}} exists but must not exist. Reason: {{REASON|u}}", new Object[]{fileThatMustNotExist.toString(), reason}).toString();
    }

    private SimpleValidationFinding.Fix getFix(String fileName, File file) {
        return log -> {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException exception) {
                throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-27").message("Failed to delete {{FILE}}.", new Object[0]).parameter("FILE", (Object)fileName).mitigation("Check file permissions.", new Object[0]).toString(), exception);
            }
        };
    }
}

