/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.AbstractFileContentValidator;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GitignoreFileValidator
extends AbstractFileContentValidator {
    private static final String NL = System.lineSeparator();
    private static final List<String> REQUIRED_LINES = List.of(".DS_Store", "*.swp", "local", ".dbeaver*", "**/*.log", ".directory", "venv/", ".idea", "*.iml", "target", ".cache", "dependency-reduced-pom.xml", ".project", ".classpath", "pom.xml.versionsBackup", "~*", "*.lock", "*.bak", "*.orig", "*.old", "*.md.html", "*.flattened-pom.xml");

    public GitignoreFileValidator(Path projectDirectory) {
        super(projectDirectory, Path.of(".gitignore", new String[0]));
    }

    @Override
    protected List<ValidationFinding> validateContent(String content) {
        ArrayList<ValidationFinding> findings = new ArrayList<ValidationFinding>();
        Set<String> entries = this.findEntries(content);
        ArrayList<String> missingEntries = new ArrayList<String>();
        for (String requiredEntry : REQUIRED_LINES) {
            if (entries.contains(requiredEntry)) continue;
            missingEntries.add(requiredEntry);
        }
        if (!missingEntries.isEmpty()) {
            findings.add(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-76").message("Invalid content of .gitignore.", new Object[0]).mitigation("Please add the following required entries: {{list of missing entries}}", new Object[]{missingEntries}).toString()).andFix(this.getAddMissingEntriesFix(content, missingEntries)).build());
        }
        return findings;
    }

    private Set<String> findEntries(String content) {
        HashSet<String> entries = new HashSet<String>();
        for (String line : content.split("\n")) {
            entries.add(line.trim());
        }
        return entries;
    }

    private SimpleValidationFinding.Fix getAddMissingEntriesFix(String content, List<String> missingEntries) {
        return log -> {
            String newContent = content + NL + String.join((CharSequence)NL, missingEntries);
            try {
                Files.writeString(this.getAbsoluteFilePath(), (CharSequence)newContent, new OpenOption[0]);
            }
            catch (IOException exception) {
                throw new UncheckedIOException(ExaError.messageBuilder((String)"E-PK-CORE-77").message("Failed to write fixed .gitignore file.", new Object[0]).toString(), exception);
            }
        };
    }

    @Override
    protected String getTemplate() {
        return String.join((CharSequence)NL, REQUIRED_LINES);
    }
}

