/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.AbstractFileContentValidator;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class LicenseFileValidator
extends AbstractFileContentValidator {
    public LicenseFileValidator(Path projectDirectory) {
        super(projectDirectory, Path.of("LICENSE", new String[0]));
    }

    @Override
    protected List<ValidationFinding> validateContent(String content) {
        return Collections.emptyList();
    }

    @Override
    protected String getTemplate() {
        Calendar calendar = Calendar.getInstance();
        return this.getTemplateFromResources().replace("!!!YEAR!!!", String.valueOf(calendar.get(1)));
    }

    private String getTemplateFromResources() {
        String string;
        block8: {
            InputStream templateStream = this.getClass().getClassLoader().getResourceAsStream("LICENSE-template");
            try {
                string = new String(templateStream.readAllBytes(), StandardCharsets.UTF_8);
                if (templateStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (templateStream != null) {
                        try {
                            templateStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException exception) {
                    throw new IllegalStateException(ExaError.messageBuilder((String)"F-PK-CORE-68").message("Failed to open LICENSE file template.", new Object[0]).ticketMitigation().toString(), exception);
                }
            }
            templateStream.close();
        }
        return string;
    }
}

