/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.mavenrepo.MavenRepository;
import com.exasol.projectkeeper.mavenrepo.Version;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class OwnVersionValidator
implements Validator {
    private final String currentVersion;
    private final MavenRepository mavenRepository;
    private final Updater updater;

    public static OwnVersionValidator forMavenPlugin(String currentVersion, Updater updater) {
        return new OwnVersionValidator(currentVersion, MavenRepository.projectKeeperMavenPlugin(), updater);
    }

    public static OwnVersionValidator forCli(String currentVersion) {
        return new OwnVersionValidator(currentVersion, MavenRepository.projectKeeperCli(), null);
    }

    private static List<ValidationFinding> findings(SimpleValidationFinding.Fix fix, String message) {
        SimpleValidationFinding.Builder builder = SimpleValidationFinding.withMessage(message).optional(true);
        if (fix != null) {
            builder.andFix(fix);
        }
        return List.of(builder.build());
    }

    OwnVersionValidator(String currentVersion, MavenRepository repo, Updater updater) {
        this.currentVersion = Objects.requireNonNull(currentVersion, "currentVersion");
        this.mavenRepository = repo;
        this.updater = updater;
    }

    @Override
    public List<ValidationFinding> validate() {
        try {
            Version current = this.parseVersion(this.currentVersion, ExaError.messageBuilder((String)"W-PK-CORE-152").message("Could not validate version of project-keeper.", new Object[0]).message(" Unsupported format of own version {{version}}.", new Object[]{this.currentVersion}).toString());
            Version latest = this.getLatestVersion(this.mavenRepository);
            if (current.isGreaterOrEqualThan(latest)) {
                return Collections.emptyList();
            }
            SimpleValidationFinding.Fix fix = this.updater == null ? null : this.updater.accept(latest.toString());
            return OwnVersionValidator.findings(fix, ExaError.messageBuilder((String)"W-PK-CORE-153").message("Project-keeper version {{current}} is outdated.", new Object[]{current}).mitigation("Please update project-keeper to latest version {{latest}}.", new Object[]{latest}).toString());
        }
        catch (ValidationException exception) {
            return OwnVersionValidator.findings(null, exception.getMessage());
        }
    }

    private Version parseVersion(String version, String message) throws ValidationException {
        try {
            return new Version(version);
        }
        catch (Version.UnsupportedVersionFormatException exception) {
            throw new ValidationException(message, exception);
        }
    }

    private Version getLatestVersion(MavenRepository repo) throws ValidationException {
        try {
            String versionString = repo.getLatestVersion();
            return this.parseVersion(versionString, ExaError.messageBuilder((String)"W-PK-CORE-154").message("Could not detect latest available version of project-keeper.", new Object[0]).message(" Unsupported format of latest version from Maven repository: {{version}}.", new Object[]{versionString}).toString());
        }
        catch (MavenRepository.XmlContentException | IOException | ParserConfigurationException | SAXException exception) {
            throw new ValidationException(ExaError.messageBuilder((String)"W-PK-CORE-155").message("Could not detect latest available version of project-keeper.", new Object[0]).message(" {{message|u}}.", new Object[]{exception.getMessage()}).mitigation("Please check network connection and response from {{url}}", new Object[]{repo.getUrl()}).toString(), exception);
        }
    }

    @FunctionalInterface
    public static interface Updater {
        public SimpleValidationFinding.Fix accept(String var1);
    }

    private static class ValidationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ValidationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

