/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.sources.AnalyzedMavenSource;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class ReleaseConfigValidator
implements Validator {
    static final String RELEASE_CONFIG = "release_config.yml";
    static final String RELEASE_MAVEN = "Maven";
    private static final String PK_CONFIG = ".project-keeper.yml";
    private static final String PK_MAVEN = ProjectKeeperModule.MAVEN_CENTRAL.toString().toLowerCase();
    private final List<AnalyzedSource> analyzedSources;
    private final Path releaseConfig;

    public ReleaseConfigValidator(Path projectDirectory, List<AnalyzedSource> analyzedSources) {
        this.releaseConfig = projectDirectory.resolve(RELEASE_CONFIG);
        this.analyzedSources = analyzedSources;
    }

    @Override
    public List<ValidationFinding> validate() {
        if (!Files.exists(this.releaseConfig, new LinkOption[0])) {
            return Collections.emptyList();
        }
        if (this.hasSourceWithMavenCentralModule() && !this.isReleasedToMavenCentral()) {
            return this.findings(ExaError.messageBuilder((String)"E-PK-CORE-165").message("At least one source uses project-keeper module {{pk module}} but releases are not published to Maven Central.", new Object[0]).mitigation("Either add release platform {{platform}} to file {{release config}}", new Object[0]).mitigation("or remove PK module {{pk module}} from all sources in file {{pk config}}.", new Object[0]).parameter("release config", (Object)RELEASE_CONFIG).parameter("platform", (Object)RELEASE_MAVEN).parameter("pk config", (Object)PK_CONFIG).parameter("pk module", (Object)PK_MAVEN).toString());
        }
        if (this.isReleasedToMavenCentral() && !this.hasSourceWithMavenCentralModule()) {
            return this.findings(ExaError.messageBuilder((String)"E-PK-CORE-166").message("Releases are configured for publication to Maven Central but no source uses project-keeper module {{pk module}}.", new Object[0]).mitigation("Either remove platform {{platform}} from file {{release config}}", new Object[0]).mitigation("or add PK module {{pk module}} to at least one of the sources in file {{pk config}}.", new Object[0]).parameter("release config", (Object)RELEASE_CONFIG).parameter("platform", (Object)RELEASE_MAVEN).parameter("pk config", (Object)PK_CONFIG).parameter("pk module", (Object)PK_MAVEN).toString());
        }
        return Collections.emptyList();
    }

    private List<ValidationFinding> findings(String message) {
        return List.of(SimpleValidationFinding.withMessage(message).build());
    }

    private boolean hasSourceWithMavenCentralModule() {
        return this.analyzedSources.stream().anyMatch(this::isMaven);
    }

    private boolean isMaven(AnalyzedSource source) {
        return source instanceof AnalyzedMavenSource && ((AnalyzedMavenSource)source).getModules().contains(ProjectKeeperModule.MAVEN_CENTRAL);
    }

    private boolean isReleasedToMavenCentral() {
        Map<String, Object> config = this.readReleaseConfig();
        if (config == null) {
            return false;
        }
        Object platforms = config.get("release-platforms");
        if (platforms == null) {
            return false;
        }
        List names = (List)platforms;
        return names.stream().anyMatch(RELEASE_MAVEN::equalsIgnoreCase);
    }

    private Map<String, Object> readReleaseConfig() {
        Map map;
        block8: {
            InputStream stream = Files.newInputStream(this.releaseConfig, new OpenOption[0]);
            try {
                map = (Map)new Yaml().load(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | YAMLException exception) {
                    throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-167").message("Failed to read file {{file}}", new Object[]{this.releaseConfig}).toString(), exception);
                }
            }
            stream.close();
        }
        return map;
    }
}

