/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changelog;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.AbstractFileContentValidator;
import com.exasol.projectkeeper.validators.VersionCollector;
import com.exasol.projectkeeper.validators.changelog.ChangelogFileGenerator;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class ChangelogFileValidator
extends AbstractFileContentValidator {
    private final Path projectDirectory;

    public ChangelogFileValidator(Path projectDirectory) {
        super(projectDirectory, Path.of("doc/changes/changelog.md", new String[0]));
        this.projectDirectory = projectDirectory;
    }

    @Override
    protected List<ValidationFinding> validateContent(String content) {
        String expectedContent = this.getTemplate();
        if (!content.trim().equals(expectedContent.trim())) {
            return List.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-69").message("The changelog.md file has an outdated content. Expected content: {{expected}}", new Object[]{expectedContent}).toString()).andFix(this.getCreateFileFix()).build());
        }
        return Collections.emptyList();
    }

    @Override
    protected String getTemplate() {
        List<ChangesFile.Filename> versions = new VersionCollector(this.projectDirectory).collectChangesFiles();
        return new ChangelogFileGenerator().generate(versions);
    }
}

