/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.projectkeeper.mavenrepo.Version;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileSection;
import com.vdurmont.semver4j.Semver;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ChangesFile {
    public static final String DEPENDENCY_UPDATES_HEADING = "## Dependency Updates";
    private final List<String> headerSectionLines;
    private final List<ChangesFileSection> sections;

    public ChangesFile(List<String> headerLines, List<ChangesFileSection> sections) {
        this.headerSectionLines = headerLines;
        this.sections = sections;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getHeaderSectionLines() {
        return this.headerSectionLines;
    }

    public String getHeading() {
        return this.headerSectionLines.get(0);
    }

    public List<ChangesFileSection> getSections() {
        return this.sections;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ChangesFile that = (ChangesFile)other;
        return Objects.equals(this.headerSectionLines, that.headerSectionLines) && Objects.equals(this.sections, that.sections);
    }

    public int hashCode() {
        return Objects.hash(this.headerSectionLines, this.sections);
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.headerSectionLines) + "\n" + this.sections.stream().map(ChangesFileSection::toString).collect(Collectors.joining("\n"));
    }

    public static class Builder {
        private final List<ChangesFileSection> sections = new ArrayList<ChangesFileSection>();
        private List<String> header = Collections.emptyList();

        private Builder() {
        }

        public Builder setHeader(List<String> header) {
            this.header = header;
            return this;
        }

        public Builder addSection(List<String> lines) {
            this.sections.add(new ChangesFileSection(lines));
            return this;
        }

        public ChangesFile build() {
            return new ChangesFile(this.header, this.sections);
        }
    }

    public static class Filename
    implements Comparable<Filename> {
        public static final Pattern PATTERN = Pattern.compile("changes_(" + Version.PATTERN.pattern() + ")\\.md");
        private final Semver version;

        public static Optional<Filename> from(Path path) {
            String filename = path.getFileName().toString();
            Matcher matcher = PATTERN.matcher(filename);
            if (!matcher.matches()) {
                return Optional.empty();
            }
            return Optional.of(new Filename(matcher.replaceFirst("$1")));
        }

        public Filename(String version) {
            this.version = new Semver(version, Semver.SemverType.LOOSE);
        }

        public String filename() {
            return "changes_" + this.version + ".md";
        }

        @Override
        public int compareTo(Filename o) {
            return this.version.compareTo(o.version);
        }

        public String version() {
            return this.version.getValue();
        }

        public int hashCode() {
            return Objects.hash(this.version);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Filename other = (Filename)obj;
            return Objects.equals(this.version, other.version);
        }
    }
}

