/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileSection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ChangesFileIO {
    private static final Pattern SECTION_HEADING_PATTERN = Pattern.compile("\\s*##\\s.*");
    private static final String LINE_SEPARATOR = System.lineSeparator();

    public ChangesFile read(Path file) {
        ChangesFile changesFile;
        BufferedReader fileReader = new BufferedReader(new FileReader(file.toFile()));
        try {
            String line;
            String sectionHeader = null;
            ChangesFile.Builder builder = ChangesFile.builder();
            ArrayList<String> lineBuffer = new ArrayList<String>();
            while ((line = fileReader.readLine()) != null) {
                if (SECTION_HEADING_PATTERN.matcher(line).matches()) {
                    this.makeSection(sectionHeader, builder, lineBuffer);
                    sectionHeader = line;
                }
                lineBuffer.add(line);
            }
            this.makeSection(sectionHeader, builder, lineBuffer);
            changesFile = builder.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new IllegalStateException(ExaError.messageBuilder((String)"F-PK-CORE-39").message("Failed to read changes file {{file}}.", new Object[0]).parameter("file", (Object)file.toString()).toString(), exception);
            }
        }
        fileReader.close();
        return changesFile;
    }

    private void makeSection(String sectionHeader, ChangesFile.Builder builder, List<String> lineBuffer) {
        if (!lineBuffer.isEmpty()) {
            if (sectionHeader == null) {
                builder.setHeader(List.copyOf(lineBuffer));
            } else {
                builder.addSection(List.copyOf(lineBuffer));
            }
            lineBuffer.clear();
        }
    }

    public void write(ChangesFile changesFile, Path destinationFile) {
        try (BufferedWriter fileWriter = new BufferedWriter(new FileWriter(destinationFile.toFile()));){
            this.writeSection(fileWriter, changesFile.getHeaderSectionLines());
            for (ChangesFileSection section : changesFile.getSections()) {
                this.writeSection(fileWriter, section.getContent());
            }
            fileWriter.flush();
        }
        catch (IOException exception) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-41").message("Failed to write changes file {{file name}}.", new Object[0]).parameter("file name", (Object)destinationFile).toString(), exception);
        }
    }

    private void writeSection(BufferedWriter fileWriter, List<String> content) throws IOException {
        for (String line : content) {
            fileWriter.write(line);
            fileWriter.write(LINE_SEPARATOR);
        }
    }
}

