/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.errorreporting.ExaError;
import java.util.List;
import java.util.Objects;

public class ChangesFileSection {
    private final List<String> content;

    public ChangesFileSection(List<String> content) {
        if (content.isEmpty()) {
            throw new IllegalStateException(ExaError.messageBuilder((String)"F-PK-CORE-36").message("changes file sections must not be empty.", new Object[0]).ticketMitigation().toString());
        }
        this.content = content;
    }

    public String getHeading() {
        return this.content.get(0);
    }

    public List<String> getContent() {
        return this.content;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ChangesFileSection that = (ChangesFileSection)other;
        return Objects.equals(this.content, that.content);
    }

    public int hashCode() {
        return Objects.hash(this.content);
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.content);
    }
}

