/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.shared.ExasolVersionMatcher;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.validators.AbstractFileValidator;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileIO;
import com.exasol.projectkeeper.validators.changesfile.DependencySectionFixer;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;

public class ChangesFileValidator
extends AbstractFileValidator {
    private final String projectName;
    private final List<AnalyzedSource> sources;
    private final String projectVersion;

    public ChangesFileValidator(String projectVersion, String projectName, Path projectDirectory, List<AnalyzedSource> sources) {
        super(projectDirectory, Path.of("doc", "changes", new ChangesFile.Filename(projectVersion).filename()));
        this.projectVersion = projectVersion;
        this.projectName = projectName;
        this.sources = sources;
    }

    @Override
    protected void writeTemplateFile(Path target) {
        new ChangesFileIO().write(this.getTemplate(), target);
    }

    @Override
    protected boolean isValidationEnabled() {
        return !new ExasolVersionMatcher().isSnapshotVersion(this.projectVersion);
    }

    @Override
    protected List<ValidationFinding> validateContent(Path file) {
        ChangesFile fixedSections;
        ChangesFile changesFile = new ChangesFileIO().read(file);
        if (!changesFile.equals(fixedSections = this.fixSections(changesFile))) {
            return List.of(this.getWrongContentFinding(fixedSections, file));
        }
        return Collections.emptyList();
    }

    private ValidationFinding getWrongContentFinding(ChangesFile fixedSections, Path file) {
        return SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-40").message("Changes file is invalid.\nExpected content:\n{{expected content}}", new Object[0]).parameter("expected content", (Object)fixedSections.toString()).toString()).andFix(log -> new ChangesFileIO().write(fixedSections, file)).build();
    }

    private ChangesFile fixSections(ChangesFile changesFile) {
        DependencySectionFixer dependencySectionFixer = new DependencySectionFixer(this.sources);
        return dependencySectionFixer.fix(changesFile);
    }

    private ChangesFile getTemplate() {
        ChangesFile changesFile = ChangesFile.builder().setHeader(List.of("# " + this.projectName + " " + this.projectVersion + ", released " + LocalDateTime.now().getYear() + "-??-??", "", "Code name:", "")).addSection(List.of("## Summary", "", "## Features", "", "* ISSUE_NUMBER: description", "")).build();
        return this.fixSections(changesFile);
    }
}

