/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.changesfile;

import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.changesfile.ChangesFileSection;
import com.exasol.projectkeeper.validators.changesfile.NamedDependencyChangeReport;
import com.exasol.projectkeeper.validators.changesfile.dependencies.DependencyChangeReportRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class DependencySectionFixer {
    private final List<AnalyzedSource> sources;

    public DependencySectionFixer(List<AnalyzedSource> sources) {
        this.sources = sources;
    }

    public ChangesFile fix(ChangesFile changesFile) {
        List<NamedDependencyChangeReport> reports = this.sources.stream().map(this::getDependencyChangesOfSource).collect(Collectors.toList());
        List<String> renderedReport = new DependencyChangeReportRenderer().render(reports);
        ArrayList<ChangesFileSection> sections = new ArrayList<ChangesFileSection>(changesFile.getSections());
        this.removeDependencySection(sections);
        if (!renderedReport.isEmpty()) {
            sections.add(new ChangesFileSection(renderedReport));
        }
        return new ChangesFile(List.copyOf(changesFile.getHeaderSectionLines()), sections);
    }

    private NamedDependencyChangeReport getDependencyChangesOfSource(AnalyzedSource source) {
        return new NamedDependencyChangeReport(source.getProjectName(), source.getDependencyChanges());
    }

    private void removeDependencySection(List<ChangesFileSection> sections) {
        sections.removeIf(section -> section.getHeading().compareToIgnoreCase("## Dependency Updates") == 0);
    }
}

