/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.projectkeeper.shared.config.BuildOptions;
import com.exasol.projectkeeper.validators.files.FileTemplate;
import com.exasol.projectkeeper.validators.files.FileTemplateFromResource;
import java.util.stream.Collectors;

class CiBuildWorkflowGenerator {
    private final BuildOptions buildOptions;

    CiBuildWorkflowGenerator(BuildOptions buildOptions) {
        this.buildOptions = buildOptions;
    }

    FileTemplate createReleaseDroidPrepareOriginalChecksumWorkflow() {
        return new FileTemplateFromResource(".github/workflows/release_droid_prepare_original_checksum.yml", FileTemplate.Validation.REQUIRE_EXACT).replacing("ciBuildRunnerOS", this.buildOptions.getRunnerOs()).replacing("freeDiskSpace", String.valueOf(this.buildOptions.shouldFreeDiskSpace()));
    }

    FileTemplateFromResource createCiBuildWorkflow() {
        FileTemplateFromResource template = new FileTemplateFromResource("templates/.github/workflows/" + this.getCiBuildTemplate(), ".github/workflows/ci-build.yml", FileTemplate.Validation.REQUIRE_EXACT).replacing("ciBuildRunnerOS", this.buildOptions.getRunnerOs()).replacing("freeDiskSpace", String.valueOf(this.buildOptions.shouldFreeDiskSpace()));
        if (this.isMatrixBuild()) {
            template.replacing("matrixExasolDbVersions", this.buildOptions.getExasolDbVersions().stream().map(this::quote).collect(Collectors.joining(", ")));
            template.replacing("defaultExasolDbVersion", this.quote((String)this.buildOptions.getExasolDbVersions().get(0)));
        }
        return template;
    }

    private String quote(String value) {
        return "\"" + value + "\"";
    }

    private String getCiBuildTemplate() {
        if (this.isMatrixBuild()) {
            return "ci-build-db-version-matrix.yml";
        }
        return "ci-build.yml";
    }

    private boolean isMatrixBuild() {
        return !this.buildOptions.getExasolDbVersions().isEmpty();
    }
}

