/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Logger;
import com.exasol.projectkeeper.shared.config.BuildOptions;
import com.exasol.projectkeeper.shared.config.ProjectKeeperModule;
import com.exasol.projectkeeper.sources.AnalyzedMavenSource;
import com.exasol.projectkeeper.sources.AnalyzedSource;
import com.exasol.projectkeeper.sources.AnalyzedSourceImpl;
import com.exasol.projectkeeper.validators.files.CiBuildWorkflowGenerator;
import com.exasol.projectkeeper.validators.files.FileTemplate;
import com.exasol.projectkeeper.validators.files.FileTemplateFromResource;
import com.exasol.projectkeeper.validators.files.ProjectKeeperShellScript;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class FileTemplatesFactory {
    private static final String POM_FILES_GENERATED = String.format("%-65s%s", "pk_generated_parent.pom", "linguist-generated=true");
    private final Logger logger;
    private final String ownVersion;
    private final boolean hasNpmModule;
    private final BuildOptions buildOptions;
    private final CiBuildWorkflowGenerator workflowGenerator;

    public FileTemplatesFactory(Logger logger, String ownVersion, boolean hasNpmModule, BuildOptions buildOptions) {
        this.logger = Objects.requireNonNull(logger, "logger");
        this.ownVersion = Objects.requireNonNull(ownVersion, "ownVersion");
        this.hasNpmModule = hasNpmModule;
        this.buildOptions = Objects.requireNonNull(buildOptions, "buildOptions");
        this.workflowGenerator = new CiBuildWorkflowGenerator(this.buildOptions);
    }

    List<FileTemplate> getGlobalTemplates(List<AnalyzedSource> sources) {
        ArrayList<FileTemplate> templates = new ArrayList<FileTemplate>();
        templates.add(new FileTemplateFromResource(".github/workflows/broken_links_checker.yml", FileTemplate.Validation.REQUIRE_EXACT));
        templates.add(new FileTemplateFromResource("release_config.yml", FileTemplate.Validation.REQUIRE_EXIST));
        templates.add(new FileTemplateFromResource(".vscode/settings.json", FileTemplate.Validation.REQUIRE_EXIST));
        Optional<AnalyzedSource> mvnRoot = sources.stream().filter(this::isMvnRootProject).findFirst();
        templates.add(new FileTemplateFromResource("templates/gitattributes", ".gitattributes", FileTemplate.Validation.REQUIRE_EXIST).replacing("pomFiles", mvnRoot.isPresent() ? POM_FILES_GENERATED : ""));
        if (mvnRoot.isPresent()) {
            templates.addAll(this.getGenericMavenTemplates(mvnRoot.get().getModules()));
            if (mvnRoot.get().getModules().contains(ProjectKeeperModule.MAVEN_CENTRAL)) {
                templates.add(new FileTemplateFromResource(".github/workflows/release_droid_release_on_maven_central.yml", FileTemplate.Validation.REQUIRE_EXACT));
            }
        } else {
            templates.addAll(this.getProjectKeeperVerifyWorkflowTemplates());
            this.logger.warn(ExaError.messageBuilder((String)"W-PK-CORE-91").message("For this project structure project keeper does not know how to configure ci-build.", new Object[0]).mitigation("Please create the required actions on your own.", new Object[0]).toString());
        }
        return templates;
    }

    private List<FileTemplate> getGenericMavenTemplates(Set<ProjectKeeperModule> modules) {
        ArrayList<FileTemplate> templates = new ArrayList<FileTemplate>();
        templates.add(this.getCiBuildTemplate(modules));
        templates.add(new FileTemplateFromResource(".github/workflows/ci-build-next-java.yml", FileTemplate.Validation.REQUIRE_EXACT).replacing("skipNativeImage", modules.contains(ProjectKeeperModule.NATIVE_IMAGE) ? "-P skipNativeImage" : ""));
        templates.add(new FileTemplateFromResource(".github/workflows/dependencies_check.yml", FileTemplate.Validation.REQUIRE_EXACT));
        templates.add(this.workflowGenerator.createReleaseDroidPrepareOriginalChecksumWorkflow());
        templates.add(new FileTemplateFromResource(".github/workflows/release_droid_print_quick_checksum.yml", FileTemplate.Validation.REQUIRE_EXACT));
        templates.add(new FileTemplateFromResource(".github/workflows/release_droid_upload_github_release_assets.yml", FileTemplate.Validation.REQUIRE_EXACT));
        return templates;
    }

    private FileTemplateFromResource getCiBuildTemplate(Set<ProjectKeeperModule> modules) {
        if (modules.contains(ProjectKeeperModule.NATIVE_IMAGE)) {
            return new FileTemplateFromResource("templates/.github/workflows/ci-build-native-build.yml", ".github/workflows/ci-build.yml", FileTemplate.Validation.REQUIRE_EXACT);
        }
        return this.workflowGenerator.createCiBuildWorkflow();
    }

    private boolean isMvnRootProject(AnalyzedSource source) {
        return source instanceof AnalyzedMavenSource && ((AnalyzedMavenSource)source).isRootProject();
    }

    List<FileTemplate> getTemplatesForSource(AnalyzedSource source) {
        if (source instanceof AnalyzedMavenSource) {
            return this.getMavenTemplates((AnalyzedMavenSource)source);
        }
        if (source instanceof AnalyzedSourceImpl) {
            return Collections.emptyList();
        }
        throw new IllegalStateException(ExaError.messageBuilder((String)"E-PK-CORE-137").message("Cannot get templates for unknown source type {{type}}", new Object[]{source.getClass().getSimpleName()}).toString());
    }

    private List<FileTemplate> getMavenTemplates(AnalyzedMavenSource source) {
        ArrayList<FileTemplate> templates = new ArrayList<FileTemplate>();
        Set<ProjectKeeperModule> enabledModules = source.getModules();
        if (enabledModules.contains(ProjectKeeperModule.DEFAULT)) {
            templates.add(new FileTemplateFromResource(".settings/org.eclipse.jdt.ui.prefs", FileTemplate.Validation.REQUIRE_EXACT));
            templates.add(new FileTemplateFromResource(".settings/org.eclipse.jdt.core.prefs", FileTemplate.Validation.REQUIRE_EXACT).replacing("javaVersion", source.getJavaVersion()));
            templates.add(new FileTemplateFromResource("src/test/resources/logging.properties", FileTemplate.Validation.REQUIRE_EXACT));
            templates.add(new FileTemplateFromResource("versionsMavenPluginRules.xml", FileTemplate.Validation.REQUIRE_EXACT));
        }
        if (enabledModules.contains(ProjectKeeperModule.JAR_ARTIFACT)) {
            templates.add(new FileTemplateFromResource("src/assembly/all-dependencies.xml", FileTemplate.Validation.REQUIRE_EXACT));
        }
        if (enabledModules.contains(ProjectKeeperModule.LOMBOK)) {
            templates.add(new FileTemplateFromResource("lombok.config", FileTemplate.Validation.REQUIRE_EXACT));
        }
        if (enabledModules.contains(ProjectKeeperModule.NATIVE_IMAGE)) {
            templates.add(new FileTemplateFromResource("src/main/reflect-config.json", FileTemplate.Validation.REQUIRE_EXIST));
        }
        return templates;
    }

    private List<FileTemplate> getProjectKeeperVerifyWorkflowTemplates() {
        ArrayList<FileTemplate> templates = new ArrayList<FileTemplate>();
        String pathInProject = ".github/workflows/project-keeper-verify.yml";
        templates.add(new FileTemplateFromResource("non_maven_templates/.github/workflows/project-keeper-verify.yml", ".github/workflows/project-keeper-verify.yml", FileTemplate.Validation.REQUIRE_EXACT).replacing("installNode", String.valueOf(this.hasNpmModule)));
        templates.add(new ProjectKeeperShellScript(this.ownVersion));
        return templates;
    }
}

