/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.projectkeeper.validators.files;

import com.exasol.errorreporting.ExaError;
import com.exasol.projectkeeper.Validator;
import com.exasol.projectkeeper.validators.VersionCollector;
import com.exasol.projectkeeper.validators.changesfile.ChangesFile;
import com.exasol.projectkeeper.validators.finding.SimpleValidationFinding;
import com.exasol.projectkeeper.validators.finding.ValidationFinding;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;

public class LatestChangesFileValidator
implements Validator {
    final Path projectDirectory;
    final String projectVersion;

    public LatestChangesFileValidator(Path projectDir, String projectVersion) {
        this.projectDirectory = projectDir;
        this.projectVersion = projectVersion;
    }

    @Override
    public List<ValidationFinding> validate() {
        List<ValidationFinding> empty = Collections.emptyList();
        List<ChangesFile.Filename> list = new VersionCollector(this.projectDirectory).collectChangesFiles();
        if (list.isEmpty()) {
            return empty;
        }
        ChangesFile.Filename latest = list.get(0);
        if (latest.version().equals(this.projectVersion)) {
            return empty;
        }
        return List.of(SimpleValidationFinding.withMessage(ExaError.messageBuilder((String)"E-PK-CORE-162").message("Found newer changes file {{filename}}.", new Object[]{latest.filename()}).mitigation("Please remove changes file later than current version {{version}}.", new Object[]{this.projectVersion}).toString()).build());
    }
}

